/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.queueing.basicqueues;

import de.uka.ipd.sdq.scheduler.SchedulerModel;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.IResourceInstance;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.processes.IActiveProcess;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.queueing.IProcessQueue;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class ProcessQueueImpl
implements IProcessQueue {
    private final SchedulerModel model;
    private final ArrayDeque<IActiveProcess> queue;
    private final Hashtable<IActiveProcess, Double> waiting_time_table = new Hashtable();

    public ProcessQueueImpl(SchedulerModel model) {
        this.model = model;
        this.queue = new ArrayDeque();
    }

    @Override
    public void addLast(IActiveProcess process) {
        this.waiting_time_table.put(process, this.model.getSimulationControl().getCurrentSimulationTime());
        this.queue.addLast(process);
    }

    @Override
    public void addFirst(IActiveProcess process) {
        this.waiting_time_table.put(process, this.model.getSimulationControl().getCurrentSimulationTime());
        this.queue.addFirst(process);
    }

    @Override
    public void add(IActiveProcess process, boolean inFront) {
        if (inFront) {
            this.addFirst(process);
        } else {
            this.addLast(process);
        }
    }

    public IActiveProcess peek() {
        return this.queue.peek();
    }

    public IActiveProcess poll() {
        IActiveProcess process = this.queue.poll();
        this.waiting_time_table.remove(process);
        return process;
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public boolean remove(IActiveProcess process) {
        this.waiting_time_table.remove(process);
        return this.queue.remove(process);
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public Iterable<IActiveProcess> ascending() {
        return new Iterable<IActiveProcess>(){

            @Override
            public Iterator<IActiveProcess> iterator() {
                return ProcessQueueImpl.this.queue.iterator();
            }
        };
    }

    @Override
    public Iterable<IActiveProcess> descending() {
        return new Iterable<IActiveProcess>(){

            @Override
            public Iterator<IActiveProcess> iterator() {
                return ProcessQueueImpl.this.queue.descendingIterator();
            }
        };
    }

    private boolean containsRunnableFor(IResourceInstance instance) {
        for (IActiveProcess process : this.queue) {
            if (!process.checkAffinity(instance)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(IActiveProcess process) {
        return this.queue.contains(process);
    }

    @Override
    public IProcessQueue getBestRunnableQueue(IResourceInstance instance) {
        if (this.containsRunnableFor(instance)) {
            return this;
        }
        return null;
    }

    @Override
    public IActiveProcess getNextRunnableProcess(IResourceInstance instance) {
        for (IActiveProcess process : this.ascending()) {
            if (!process.checkAffinity(instance)) continue;
            return process;
        }
        return null;
    }

    @Override
    public IActiveProcess getNextRunnableProcess() {
        return this.peek();
    }

    @Override
    public void identifyMovableProcesses(IResourceInstance targetInstance, boolean prio_increasing, boolean queue_ascending, int processes_needed, List<IActiveProcess> process_list) {
        Iterable<IActiveProcess> queue_direction = queue_ascending ? this.ascending() : this.descending();
        for (IActiveProcess process : queue_direction) {
            if (!process.isMovable(targetInstance)) continue;
            process_list.add(process);
            if (process_list.size() >= processes_needed) break;
        }
    }

    @Override
    public IProcessQueue createNewInstance() {
        return new ProcessQueueImpl(this.model);
    }

    @Override
    public boolean processStarving(double threshold) {
        double now = this.model.getSimulationControl().getCurrentSimulationTime();
        for (IActiveProcess process : this.ascending()) {
            double waiting_time = now - this.waiting_time_table.get(process);
            if (!(waiting_time > threshold)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setWaitingTime(IActiveProcess process, double waiting) {
        this.waiting_time_table.put(process, waiting);
    }

    @Override
    public double getWaitingTime(IActiveProcess process) {
        return this.waiting_time_table.get(process);
    }

    @Override
    public List<IActiveProcess> getStarvingProcesses(double starvationLimit) {
        double now = this.model.getSimulationControl().getCurrentSimulationTime();
        ArrayList<IActiveProcess> result = new ArrayList<IActiveProcess>();
        for (IActiveProcess process : this.ascending()) {
            Double time = this.waiting_time_table.get(process);
            double waiting_time = now - time;
            if (!(waiting_time > starvationLimit)) continue;
            result.add(process);
        }
        return result;
    }
}

