/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.resources.passive;

import de.uka.ipd.sdq.scheduler.ISchedulableProcess;
import de.uka.ipd.sdq.scheduler.LoggingWrapper;
import de.uka.ipd.sdq.scheduler.SchedulerModel;
import de.uka.ipd.sdq.scheduler.resources.passive.PassiveResourceObservee;
import de.uka.ipd.sdq.scheduler.sensors.IPassiveResourceSensor;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.SimActiveResource;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.events.IDelayedAction;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.priority.IPriorityBoost;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.processes.IActiveProcess;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.processes.impl.ProcessWithPriority;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.resources.passive.SimAbstractPassiveResource;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.resources.passive.WaitingProcess;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.repository.PassiveResource;

public class SimUnfairPassiveResource
extends SimAbstractPassiveResource {
    private final double acquisition_demand;
    private final boolean isFifo;
    private long available;
    private final PassiveResourceObservee observee;

    public SimUnfairPassiveResource(SchedulerModel model, long capacity, PassiveResource passiveResource, IPriorityBoost priority_boost, SimActiveResource managing_resource, double acquisition_demand, boolean isFifo, AssemblyContext assemblyContext) {
        super(model, capacity, passiveResource, priority_boost, managing_resource, assemblyContext);
        this.acquisition_demand = acquisition_demand;
        this.isFifo = isFifo;
        this.available = capacity;
        this.observee = new PassiveResourceObservee();
    }

    public boolean acquire(ISchedulableProcess sched_process, long num, boolean timeout, double timeoutValue) {
        if (!this.getModel().getSimulationControl().isRunning()) {
            return true;
        }
        this.observee.fireRequest(sched_process, num);
        ProcessWithPriority process = (ProcessWithPriority)this.main_resource.lookUp(sched_process);
        if (num <= this.available) {
            this.grantAccess(num, process);
            return true;
        }
        LoggingWrapper.log((String)("Process " + process + " is waiting for " + num + " of " + (Object)((Object)this)));
        WaitingProcess waiting_process = new WaitingProcess(process, num);
        this.fromRunningToWaiting(waiting_process, !this.isFifo);
        process.getSchedulableProcess().passivate();
        return false;
    }

    private void grantAccess(long num, ProcessWithPriority process) {
        LoggingWrapper.log((String)("Process " + process + " acquires " + num + " of " + (Object)((Object)this)));
        this.punish(process);
        this.boostPriority(process);
        this.available -= num;
        this.observee.fireAquire(process.getSchedulableProcess(), num);
        assert (this.available >= 0L) : "More resource than available have been acquired!";
    }

    public void release(ISchedulableProcess sched_process, long num) {
        if (!this.getModel().getSimulationControl().isRunning()) {
            return;
        }
        LoggingWrapper.log((String)("Process " + sched_process + " releases " + num + " of " + (Object)((Object)this)));
        this.available += num;
        this.observee.fireRelease(sched_process, num);
        this.notifyNextWaitingProcess();
    }

    private void notifyNextWaitingProcess() {
        WaitingProcess waiting_process = (WaitingProcess)this.waiting_queue.peek();
        if (waiting_process != null) {
            IActiveProcess process = waiting_process.getActiveProcess();
            process.setCurrentDemand(this.acquisition_demand);
            process.setDelayedAction(new UnfairAccessAction(waiting_process));
            this.fromWaitingToReady(waiting_process, process.getLastInstance());
        }
    }

    protected boolean tryToDequeueProcess(WaitingProcess waitingProcess) {
        if (waitingProcess.getNumRequested() <= this.available) {
            this.grantAccess(waitingProcess.getNumRequested(), (ProcessWithPriority)waitingProcess.getActiveProcess());
            if (this.available > 0L) {
                this.notifyNextWaitingProcess();
            }
            return true;
        }
        return false;
    }

    public void addObserver(IPassiveResourceSensor observer) {
        this.observee.addObserver(observer);
    }

    public void removeObserver(IPassiveResourceSensor observer) {
        this.observee.removeObserver(observer);
    }

    public long getAvailable() {
        return this.available;
    }

    private class UnfairAccessAction
    implements IDelayedAction {
        private final WaitingProcess waiting_process;

        public UnfairAccessAction(WaitingProcess waiting_process) {
            this.waiting_process = waiting_process;
        }

        @Override
        public boolean perform() {
            if (!SimUnfairPassiveResource.this.tryToDequeueProcess(this.waiting_process)) {
                SimUnfairPassiveResource.this.fromRunningToWaiting(this.waiting_process, true);
                return false;
            }
            this.waiting_process.getActiveProcess().getSchedulableProcess().activate();
            return true;
        }
    }
}

