/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.sensors.impl;

import de.uka.ipd.sdq.scheduler.SchedulerModel;
import de.uka.ipd.sdq.scheduler.processes.PROCESS_STATE;
import de.uka.ipd.sdq.scheduler.sensors.IProcessStateSensor;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.processes.IActiveProcess;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.processes.impl.ProcessWithPriority;

public class SleepAverageSensor
implements IProcessStateSensor {
    private final SchedulerModel model;
    private PROCESS_STATE last_state;
    private double lastUpdateTime;
    private double sleep_average;
    private final double max_sleep_average;
    private final int max_bonus;
    private int last_bonus;
    private static double FACTOR = 0.5;

    public SleepAverageSensor(SchedulerModel model, IActiveProcess process, double max_sleep_average, int max_bonus) {
        this.model = model;
        this.lastUpdateTime = model.getSimulationControl().getCurrentSimulationTime();
        this.last_state = process.getState();
        this.max_sleep_average = max_sleep_average;
        this.max_bonus = max_bonus;
        this.last_bonus = (int)Math.ceil((double)max_bonus * FACTOR);
        this.sleep_average = this.interactiveSleep((ProcessWithPriority)process);
        this.update(process.getState());
    }

    public double getSleepAverage() {
        this.update(this.last_state);
        return this.sleep_average;
    }

    public double getMaxSleepAverage() {
        return this.max_sleep_average;
    }

    public void update(PROCESS_STATE new_state) {
        double currentTime = this.model.getSimulationControl().getCurrentSimulationTime();
        double passedTime = currentTime - this.lastUpdateTime;
        if (this.last_state == PROCESS_STATE.WAITING) {
            this.sleep_average = Math.min(this.max_sleep_average, this.sleep_average + Math.floor(passedTime));
        }
        if (this.last_state == PROCESS_STATE.RUNNING) {
            this.sleep_average = Math.max(0.0, this.sleep_average - (passedTime /= (double)(this.last_bonus > 0 ? this.last_bonus : 1)));
        }
        this.lastUpdateTime = currentTime;
        if (this.last_state != PROCESS_STATE.WAITING || new_state == PROCESS_STATE.RUNNING) {
            this.last_state = new_state;
        }
    }

    public int getCurrentBonus() {
        this.update(this.last_state);
        this.last_bonus = (int)Math.floor((double)this.msToJiffies(this.sleep_average) * (double)this.max_bonus / (double)this.msToJiffies(this.max_sleep_average));
        return this.last_bonus;
    }

    public int msToJiffies(double time) {
        int jiffies = (int)Math.ceil(time / 10.0);
        return jiffies;
    }

    public double jiffiesToMs(int jiffies) {
        return (double)jiffies * 10.0;
    }

    public double interactiveSleep(ProcessWithPriority p) {
        int scale = (p.getDynamicPriority().getValue() + 20) * this.max_bonus / 40;
        int delta = scale - 20 * this.max_bonus / 40 + 2;
        int result = this.msToJiffies(this.max_sleep_average) * (this.max_bonus / 2 + delta + 1) / this.max_bonus - 1;
        return this.jiffiesToMs(result);
    }
}

