/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.strategy.impl;

import de.uka.ipd.sdq.scheduler.ISchedulableProcess;
import de.uka.ipd.sdq.scheduler.SchedulerModel;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.IResourceInstance;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.SimActiveResource;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.priority.update.SetToBaseUpdate;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.processes.IActiveProcess;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.processes.impl.ProcessWithPriority;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.queueing.IQueueingStrategy;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.resources.active.SimResourceInstance;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.strategy.impl.AbstractScheduler;
import scheduler.configuration.StarvationBoost;

public class PreemptiveScheduler
extends AbstractScheduler {
    public PreemptiveScheduler(SchedulerModel model, SimActiveResource resource, IQueueingStrategy queueingStrategy, boolean in_front_after_waiting, double scheduling_interval, StarvationBoost starvationBoost) {
        super(resource, queueingStrategy, in_front_after_waiting, starvationBoost);
        this.scheduling_interval = scheduling_interval;
    }

    @Override
    public void schedule(IResourceInstance instance) {
        if (instance.isScheduling()) {
            return;
        }
        this.queueing_strategy.activelyBalance(instance);
        ProcessWithPriority running_process = (ProcessWithPriority)instance.getRunningProcess();
        this.toNow(running_process);
        if (running_process != null) {
            if (running_process.getTimeslice().isFinished()) {
                this.unschedule(running_process, false, instance);
            } else {
                this.unschedule(running_process, true, instance);
            }
        }
        this.scheduleNextProcess(instance);
        this.scheduleNextEvent(instance);
    }

    private void scheduleNextProcess(ProcessWithPriority next_process, IResourceInstance instance) {
        if (next_process != null) {
            next_process.toNow();
            next_process.update();
            this.fromReadyToRunningOn(next_process, instance);
        }
    }

    private void scheduleNextProcess(IResourceInstance instance) {
        this.lookForStarvingProcessesAndApplyStarvationBoost(instance);
        ProcessWithPriority next_process = (ProcessWithPriority)this.queueing_strategy.getNextProcessFor(instance);
        this.scheduleNextProcess(next_process, instance);
    }

    private void lookForStarvingProcessesAndApplyStarvationBoost(IResourceInstance instance) {
        if (this.starvationBoost != null) {
            for (IActiveProcess p : this.queueing_strategy.getStarvingProcesses(instance, this.starvationBoost.getStarvationLimit())) {
                this.applyStarvationBoost((ProcessWithPriority)p);
            }
        }
    }

    private void applyStarvationBoost(ProcessWithPriority p) {
        p.setToStaticPriorityWithBonus(this.starvationBoost.getBoost());
        SetToBaseUpdate priorityUpdateStrategy = new SetToBaseUpdate(this.starvationBoost.getDurationInTimeslices());
        p.setPriorityUpdateStrategy(priorityUpdateStrategy);
    }

    private void toNow(ProcessWithPriority process) {
        if (process != null) {
            process.toNow();
        }
    }

    private void unschedule(ProcessWithPriority running_process, boolean next_has_higher_priority, IResourceInstance current) {
        if (running_process != null) {
            if (running_process.getTimeslice().isFinished()) {
                running_process.update();
                this.fromRunningToReady(running_process, current, false);
                running_process.getTimeslice().fullReset();
            } else {
                this.fromRunningToReady(running_process, current, next_has_higher_priority);
            }
            if (running_process.getRunQueue().getCurrentLoad() == 1) {
                running_process.getRunQueue().resetStarvationInfo();
            }
        }
    }

    @Override
    public void scheduleNextEvent(IResourceInstance instance) {
        ProcessWithPriority running = (ProcessWithPriority)instance.getRunningProcess();
        if (running != null) {
            running.toNow();
            double remainingTime = running.getTimeslice().getRemainingTime();
            double currentDemand = running.getCurrentDemand();
            if (currentDemand < remainingTime) {
                running.scheduleProceedEvent(this);
            } else {
                instance.scheduleSchedulingEvent(remainingTime);
            }
        } else if (!this.queueing_strategy.isIdle(instance)) {
            instance.scheduleSchedulingEvent(0.0);
        } else {
            instance.scheduleSchedulingEvent(this.scheduling_interval);
        }
    }

    @Override
    public boolean isIdle(IResourceInstance instance) {
        return this.queueing_strategy.isIdle(instance);
    }

    @Override
    public double getInterval() {
        return this.scheduling_interval;
    }

    @Override
    public void terminateProcess(IActiveProcess process, IResourceInstance current) {
        super.terminateProcess(process, current);
        ISchedulableProcess sProcess = process.getSchedulableProcess();
        if (sProcess.isFinished() && sProcess.getRootProcess() != sProcess) {
            this.resource.unregisterProcess(process);
        }
    }

    @Override
    public int getQueueLengthFor(SimResourceInstance simResourceInstance) {
        return this.queueing_strategy.getQueueLengthFor(simResourceInstance);
    }
}

