/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.timeslice.impl;

import de.uka.ipd.sdq.probfunction.math.util.MathTools;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.timeslice.ITimeSlice;

public class ContinuousTimeSlice
implements ITimeSlice {
    protected double remaining_time;
    protected double timeslice;

    public ContinuousTimeSlice(double timeslice) {
        this.timeslice = timeslice;
        this.remaining_time = 0.0;
    }

    protected ContinuousTimeSlice() {
        this.timeslice = 0.0;
        this.remaining_time = 0.0;
    }

    @Override
    public boolean isFinished() {
        return MathTools.equalsDouble((double)this.remaining_time, (double)0.0);
    }

    @Override
    public void substractTime(double time) {
        this.remaining_time -= time;
        assert (MathTools.lessOrEqual((double)0.0, (double)this.remaining_time)) : "Timeslice exceeded: " + this.remaining_time;
    }

    @Override
    public void fullReset() {
        this.remaining_time = this.timeslice;
    }

    @Override
    public double getRemainingTime() {
        return this.remaining_time;
    }

    @Override
    public void punish(int penalty) {
        double time = Math.min((double)penalty, this.remaining_time);
        this.substractTime(time);
    }

    @Override
    public void setExpired() {
        this.remaining_time = 0.0;
    }

    @Override
    public ITimeSlice clone() {
        ContinuousTimeSlice cts = new ContinuousTimeSlice();
        cts.timeslice = this.timeslice;
        cts.remaining_time = this.remaining_time;
        return cts;
    }

    @Override
    public void halfReset() {
    }

    @Override
    public void updateTimeForBoosting() {
    }

    @Override
    public void updateTimeForScheduling() {
    }
}

