/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.loaddistribution.balancers;

import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.IResourceInstance;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.loaddistribution.balancers.AbstractLoadBalancer;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.processes.IActiveProcess;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.processes.impl.PreemptiveProcess;
import java.util.List;

public class OneToIdleBalancer
extends AbstractLoadBalancer {
    private int upperBound = 1;
    private int lowerBound = 1;

    public OneToIdleBalancer(double balance_interval, boolean prio_increasing, boolean queue_ascending) {
        super(balance_interval, prio_increasing, queue_ascending);
    }

    @Override
    public void activelyBalance(IResourceInstance instance) {
    }

    @Override
    public void onFork(IResourceInstance instance) {
        this.balanceAsSender(instance);
    }

    @Override
    public void onSleep(IResourceInstance instance) {
        this.balanceAsReceiver(instance);
    }

    @Override
    public void onTerminate(IResourceInstance instance) {
        this.balanceAsReceiver(instance);
    }

    @Override
    public void onWake(IResourceInstance instance) {
        this.balanceAsSender(instance);
    }

    private void balanceAsSender(IResourceInstance instance) {
        if (this.load(instance) > this.upperBound) {
            this.balance(instance, this.getReceiver());
        }
    }

    private void balanceAsReceiver(IResourceInstance instance) {
        if (this.load(instance) < this.lowerBound) {
            this.balance(this.getSender(), instance);
        }
    }

    private IResourceInstance getSender() {
        IResourceInstance result = null;
        for (IResourceInstance ri : this.queue_holder.getResourceInstances()) {
            if (result != null && this.load(ri) <= this.load(result)) continue;
            result = ri;
        }
        if (this.load(result) > this.upperBound) {
            return result;
        }
        return null;
    }

    private IResourceInstance getReceiver() {
        IResourceInstance result = null;
        for (IResourceInstance ri : this.queue_holder.getResourceInstances()) {
            if (result != null && this.load(ri) >= this.load(result)) continue;
            result = ri;
        }
        if (this.load(result) < this.lowerBound) {
            return result;
        }
        return null;
    }

    private void balance(IResourceInstance sender, IResourceInstance receiver) {
        List<IActiveProcess> processList;
        if (sender != null && receiver != null && !sender.equals(receiver) && (processList = this.queue_holder.getRunQueueFor(sender).identifyMovableProcesses(receiver, this.prio_increasing, this.queue_ascending, 1)).size() > 0) {
            this.fakeThreadLoadBalancing(processList.get(0), sender, receiver);
        }
    }

    private void fakeThreadLoadBalancing(IActiveProcess process, IResourceInstance sender, IResourceInstance receiver) {
        PreemptiveProcess p;
        if (receiver.getLastRunningProcess() != null && (p = (PreemptiveProcess)receiver.getLastRunningProcess()).isWaiting()) {
            p.setLastInstance(process.getLastInstance());
            p.setIdealInstance(process.getIdealInstance());
        }
        this.queue_holder.move(process, sender, receiver);
    }
}

