/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.loaddistribution.balancers;

import de.uka.ipd.sdq.scheduler.SchedulerModel;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.IResourceInstance;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.loaddistribution.balancers.AbstractLoadBalancer;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.processes.IActiveProcess;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.processes.impl.PreemptiveProcess;
import java.util.List;

public class ToThresholdBalancer
extends AbstractLoadBalancer {
    private SchedulerModel model;
    private double last_balanced = 0.0;
    private int threshold;

    public ToThresholdBalancer(SchedulerModel model, double balancing_interval, boolean prio_increasing, boolean queue_ascending, int threshold) {
        super(balancing_interval, prio_increasing, queue_ascending);
        this.model = model;
        this.threshold = threshold;
    }

    @Override
    public void activelyBalance(IResourceInstance instance) {
        double now = this.model.getSimulationControl().getCurrentSimulationTime();
        if (now - this.last_balanced > this.balancing_interval) {
            this.balance(this.getBusiest(), this.getLaziest());
            this.last_balanced = now;
        }
    }

    @Override
    public void onFork(IResourceInstance instance) {
        this.balance(instance, this.getLaziest());
    }

    @Override
    public void onSleep(IResourceInstance instance) {
        if (this.load(instance) == 0) {
            this.balance(this.getBusiest(), instance);
        }
    }

    @Override
    public void onTerminate(IResourceInstance instance) {
        if (this.load(instance) == 0) {
            this.balance(this.getBusiest(), instance);
        }
    }

    @Override
    public void onWake(IResourceInstance instance) {
        this.balance(instance, this.getLaziest());
    }

    private void balance(IResourceInstance sender, IResourceInstance receiver) {
        int distance;
        if (sender != null && receiver != null && !sender.equals(receiver) && (distance = this.load(sender) - this.load(receiver)) > this.threshold) {
            List<IActiveProcess> processList = this.queue_holder.getRunQueueFor(sender).identifyMovableProcesses(receiver, this.prio_increasing, this.queue_ascending, distance / 2);
            for (IActiveProcess process : processList) {
                this.fakeThreadLoadBalancing(process, sender, receiver);
            }
        }
    }

    private void fakeThreadLoadBalancing(IActiveProcess process, IResourceInstance sender, IResourceInstance receiver) {
        PreemptiveProcess p;
        if (receiver.getLastRunningProcess() != null && (p = (PreemptiveProcess)receiver.getLastRunningProcess()).isWaiting()) {
            p.setLastInstance(process.getLastInstance());
            p.setIdealInstance(process.getIdealInstance());
        }
        this.queue_holder.move(process, sender, receiver);
    }

    private IResourceInstance getLaziest() {
        IResourceInstance result = null;
        for (IResourceInstance ri : this.queue_holder.getResourceInstances()) {
            if (result != null && this.load(ri) >= this.load(result)) continue;
            result = ri;
        }
        return result;
    }

    private IResourceInstance getBusiest() {
        IResourceInstance result = null;
        for (IResourceInstance ri : this.queue_holder.getResourceInstances()) {
            if (result != null && this.load(ri) <= this.load(result)) continue;
            result = ri;
        }
        return result;
    }
}

