/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.priority.impl;

import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.priority.IPriority;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.priority.IPriorityManager;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.priority.impl.PriorityManagerImpl;

public class PriorityImpl
implements IPriority {
    protected PriorityManagerImpl manager;
    protected int value;
    protected int absolute_value;

    protected PriorityImpl(int value, PriorityManagerImpl manager) {
        this.manager = manager;
        this.setValue(value);
    }

    @Override
    public int absoluteValue() {
        return this.absolute_value;
    }

    @Override
    public IPriorityManager getManager() {
        return this.manager;
    }

    @Override
    public boolean greaterThan(IPriority prio) {
        return this.manager.direction > 0 ? this.getValue() > prio.getValue() : this.getValue() < prio.getValue();
    }

    @Override
    public boolean lessOrEqual(IPriority prio) {
        return this.manager.direction > 0 ? this.getValue() <= prio.getValue() : this.getValue() >= prio.getValue();
    }

    @Override
    public IPriority increase() {
        return new PriorityImpl(this.value + this.manager.direction, this.manager);
    }

    @Override
    public IPriority decrease() {
        return new PriorityImpl(this.value - this.manager.direction, this.manager);
    }

    @Override
    public int distance(IPriority prio) {
        return Math.abs(this.getValue() - prio.getValue());
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public void setValue(int value) {
        this.value = value;
        this.absolute_value = Math.abs(value - this.manager.lowest_value);
    }

    @Override
    public void setTo(IPriority priority) {
        this.setValue(priority.getValue());
    }

    @Override
    public IPriority addBonus(int bonus) {
        int new_value = this.getValue() + (bonus *= this.manager.direction);
        if (this.manager.direction > 0) {
            new_value = Math.max(new_value, this.manager.lowest_value);
            new_value = Math.min(new_value, this.manager.highest_value);
        } else {
            new_value = Math.min(new_value, this.manager.lowest_value);
            new_value = Math.max(new_value, this.manager.highest_value);
        }
        return new PriorityImpl(new_value, this.manager);
    }

    public int hashCode() {
        return this.absolute_value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PriorityImpl) {
            PriorityImpl prio = (PriorityImpl)obj;
            return prio.value == this.value;
        }
        return false;
    }

    @Override
    public IPriority clone() {
        return new PriorityImpl(this.value, this.manager);
    }

    public String toString() {
        return "" + this.value;
    }
}

