/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofile.application.decorator.reflective;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.modelversioning.emfprofile.application.registry.ui.extensionpoint.decorator.EMFProfileApplicationDecorator;
import org.modelversioning.emfprofile.application.registry.ui.extensionpoint.decorator.PluginExtensionOperationsListener;

public class EMFProfileApplicationDecoratorImpl
implements EMFProfileApplicationDecorator,
ISelectionListener {
    private static final String ECORE_REFLECTIVE_EDITOR_ID = "org.eclipse.emf.ecore.presentation.ReflectiveEditorID";
    private static final String ECORE_EDITOR_ID = "org.eclipse.emf.ecore.presentation.EcoreEditorID";
    private static final String[] CAN_DECORATE_EDITORS = new String[]{"org.eclipse.emf.ecore.presentation.ReflectiveEditorID", "org.eclipse.emf.ecore.presentation.EcoreEditorID"};
    private static PluginExtensionOperationsListener pluginExtensionOperationsListener;
    private IEditorPart activeEditor = null;

    public EMFProfileApplicationDecoratorImpl() {
        this.getActiveEditorAndCheckWhetherToDecorate();
    }

    private void getActiveEditorAndCheckWhetherToDecorate() {
        String editorId;
        IWorkbenchPage activePage = this.getActivePage();
        IEditorPart editorPart = activePage.getActiveEditor();
        if (editorPart != null && this.isDecorateable(editorId = this.getEditorId(editorPart))) {
            this.activeEditor = editorPart;
            this.activeEditor.getSite().getPage().addSelectionListener(editorId, (ISelectionListener)this);
        }
        activePage.addPartListener(new IPartListener(){

            public void partOpened(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
                if (part instanceof IEditorPart && part.equals(EMFProfileApplicationDecoratorImpl.this.activeEditor)) {
                    EMFProfileApplicationDecoratorImpl.this.activeEditor.getSite().getPage().removeSelectionListener((ISelectionListener)EMFProfileApplicationDecoratorImpl.this);
                }
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partActivated(IWorkbenchPart part) {
                IEditorPart editorPart;
                if (part instanceof IEditorPart && EMFProfileApplicationDecoratorImpl.this.isDecorateable(EMFProfileApplicationDecoratorImpl.this.getEditorId(editorPart = (IEditorPart)part))) {
                    if (EMFProfileApplicationDecoratorImpl.this.activeEditor != null) {
                        EMFProfileApplicationDecoratorImpl.this.activeEditor.getSite().getPage().removeSelectionListener((ISelectionListener)EMFProfileApplicationDecoratorImpl.this);
                    }
                    EMFProfileApplicationDecoratorImpl.this.activeEditor = (IEditorPart)part;
                    EMFProfileApplicationDecoratorImpl.this.activeEditor.getSite().getPage().addSelectionListener((ISelectionListener)EMFProfileApplicationDecoratorImpl.this);
                }
            }
        });
    }

    public IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            throw new RuntimeException("could not locate workbench active window!");
        }
        IWorkbenchPage activePage = window.getActivePage();
        if (activePage == null) {
            throw new RuntimeException("could not locate active page for active window ");
        }
        return activePage;
    }

    private String getEditorId(IEditorPart editorPart) {
        return editorPart.getSite().getId();
    }

    private boolean isDecorateable(String editorId) {
        String[] stringArray = CAN_DECORATE_EDITORS;
        int n = CAN_DECORATE_EDITORS.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (id.equals(editorId)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String[] canDecorateEditorParts() {
        return CAN_DECORATE_EDITORS;
    }

    public void setPluginExtensionOperationsListener(PluginExtensionOperationsListener listener) {
        pluginExtensionOperationsListener = listener;
    }

    public void decorate(EObject eObject, List<Image> images, List<String> toolTipTexts) {
    }

    public static PluginExtensionOperationsListener getPluginExtensionOperationsListener() {
        return pluginExtensionOperationsListener;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (pluginExtensionOperationsListener != null && part instanceof IEditorPart && part.equals(this.activeEditor) && selection != null && selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object element = structuredSelection.getFirstElement();
            if (element instanceof EObject) {
                EObject selectedEObject = (EObject)element;
                EMFProfileApplicationDecoratorImpl.getPluginExtensionOperationsListener().eObjectSelected(selectedEObject);
            } else {
                EMFProfileApplicationDecoratorImpl.getPluginExtensionOperationsListener().eObjectSelected(null);
            }
        }
    }
}

