/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofile.application.registry.ui.commands.handlers;

import java.io.IOException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.modelversioning.emfprofile.application.registry.ProfileApplicationDecorator;
import org.modelversioning.emfprofile.application.registry.ProfileApplicationRegistry;
import org.modelversioning.emfprofile.application.registry.ui.observer.ActiveEditorObserver;

public class SaveAllProfileApplicationsHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (ActiveEditorObserver.INSTANCE.getLastActiveEditorPart() != null) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    for (ProfileApplicationDecorator profileApplication : ProfileApplicationRegistry.INSTANCE.getProfileApplications(ActiveEditorObserver.INSTANCE.getModelIdForWorkbenchPart(ActiveEditorObserver.INSTANCE.getLastActiveEditorPart()))) {
                        if (!profileApplication.isDirty()) continue;
                        SaveAllProfileApplicationsHandler.this.saveProfileApplication(profileApplication);
                    }
                }
            });
        }
        return null;
    }

    private void saveProfileApplication(final ProfileApplicationDecorator profileApplication) {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                try {
                    try {
                        profileApplication.save();
                    }
                    catch (IOException | CoreException e) {
                        SaveAllProfileApplicationsHandler.this.showError("Error while saving profile application resource", e);
                        ActiveEditorObserver.INSTANCE.updateViewer(profileApplication);
                    }
                }
                finally {
                    ActiveEditorObserver.INSTANCE.updateViewer(profileApplication);
                }
            }
        };
        try {
            new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()).run(true, false, (IRunnableWithProgress)operation);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showError("Error while saving profile application resource", e);
        }
    }

    private void showError(String message, Throwable throwable) {
        ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Error Occured", (String)message, (IStatus)new Status(4, "org.modelversioning.emfprofile.application.registry.ui", throwable.getMessage(), throwable));
    }
}

