/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofile.application.registry.ui.extensionpoint.decorator.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.modelversioning.emfprofile.application.registry.ui.extensionpoint.decorator.EMFProfileApplicationDecorator;
import org.modelversioning.emfprofile.application.registry.ui.extensionpoint.decorator.PluginExtensionOperationsListener;

public class EMFProfileApplicationDecoratorHandler {
    private static EMFProfileApplicationDecoratorHandler INSTANCE;
    public static final String DECORATOR_ID = "org.modelversioning.emfprofile.application.registry.ui.extensionpoint.decorator";
    private Map<String, Collection<EMFProfileApplicationDecorator>> decorators = new HashMap<String, Collection<EMFProfileApplicationDecorator>>();

    public static EMFProfileApplicationDecoratorHandler getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EMFProfileApplicationDecoratorHandler();
        }
        return INSTANCE;
    }

    private EMFProfileApplicationDecoratorHandler() {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(DECORATOR_ID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            System.out.println("Evaluating extension");
            Object o = null;
            try {
                o = e.createExecutableExtension("class");
            }
            catch (CoreException e2) {
                e2.printStackTrace();
            }
            if (o != null) {
                EMFProfileApplicationDecorator decorator = (EMFProfileApplicationDecorator)o;
                String[] supportedEditorIDs = null;
                try {
                    String[] stringArray = supportedEditorIDs = decorator.canDecorateEditorParts();
                    int n3 = supportedEditorIDs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String id = stringArray[n4];
                        if (!this.decorators.containsKey(id)) {
                            this.decorators.put(id, new ArrayList());
                        }
                        this.decorators.get(id).add(decorator);
                        ++n4;
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            ++n2;
        }
        System.out.println("DECORATOR HANDLER CONTAINS FOLLOWING DECORATORS:");
        for (String id : this.decorators.keySet()) {
            System.out.println("editor id: " + id + ", has decorators amount: " + this.decorators.get(id).size());
        }
    }

    public boolean hasDecoratorForEditorPart(IWorkbenchPart part) {
        if (part instanceof IEditorPart) {
            return this.decorators.containsKey(part.getSite().getId());
        }
        return false;
    }

    public EMFProfileApplicationDecorator getDecoratorForEditorPart(IWorkbenchPart part) {
        return this.decorators.get(part.getSite().getId()).iterator().next();
    }

    public void setPluginExtensionOperationsListener(PluginExtensionOperationsListener listener) {
        for (Collection<EMFProfileApplicationDecorator> _decorators : this.decorators.values()) {
            for (EMFProfileApplicationDecorator emfProfileApplicationDecorator : _decorators) {
                emfProfileApplicationDecorator.setPluginExtensionOperationsListener(listener);
            }
        }
    }

    public void unsetPluginExtensionOperationsListener() {
        for (Collection<EMFProfileApplicationDecorator> _decorators : this.decorators.values()) {
            for (EMFProfileApplicationDecorator emfProfileApplicationDecorator : _decorators) {
                emfProfileApplicationDecorator.setPluginExtensionOperationsListener(null);
            }
        }
    }
}

