/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofile.application.registry.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.modelversioning.emfprofile.Profile;
import org.modelversioning.emfprofile.application.registry.ProfileApplicationDecorator;
import org.modelversioning.emfprofile.application.registry.ProfileApplicationRegistry;
import org.modelversioning.emfprofile.application.registry.internal.ProfileApplicationDecoratorImpl;
import org.modelversioning.emfprofile.application.registry.internal.ProfileApplicationManager;
import org.modelversioning.emfprofileapplication.ProfileApplication;

public class ProfileApplicationRegistryImpl
implements ProfileApplicationRegistry {
    public static final ProfileApplicationRegistry INSTANCE = new ProfileApplicationRegistryImpl();
    private Map<String, ProfileApplicationManager> modelledResourceProfilesApplicationsManagerMap = new HashMap<String, ProfileApplicationManager>();
    private ResourceSet resourceSet = new ResourceSetImpl();

    private ProfileApplicationRegistryImpl() {
    }

    @Override
    public void applyProfileToModel(String modelId, IFile profileApplicationsFile, Collection<Profile> profiles, ResourceSet resourceSet) throws Exception {
        ProfileApplicationManager pam;
        if (!this.modelledResourceProfilesApplicationsManagerMap.containsKey(modelId)) {
            pam = resourceSet == null ? new ProfileApplicationManager(this.resourceSet) : new ProfileApplicationManager(resourceSet);
            this.modelledResourceProfilesApplicationsManagerMap.put(modelId, pam);
        }
        pam = this.modelledResourceProfilesApplicationsManagerMap.get(modelId);
        pam.createNewProfileApplication(profileApplicationsFile, profiles);
    }

    @Override
    public ProfileApplicationDecorator loadProfileApplicationForModel(String modelId, IFile profileApplicationFile, ResourceSet resourceSet) throws Exception {
        ProfileApplicationManager pam;
        if (!this.modelledResourceProfilesApplicationsManagerMap.containsKey(modelId)) {
            pam = resourceSet == null ? new ProfileApplicationManager(this.resourceSet) : new ProfileApplicationManager(resourceSet);
            this.modelledResourceProfilesApplicationsManagerMap.put(modelId, pam);
        }
        pam = this.modelledResourceProfilesApplicationsManagerMap.get(modelId);
        Collection<ProfileApplicationDecorator> elements = pam.getProfileApplications();
        for (ProfileApplicationDecorator element : elements) {
            ProfileApplicationDecoratorImpl elementImpl = (ProfileApplicationDecoratorImpl)element;
            if (!profileApplicationFile.getLocation().toString().equals(elementImpl.getProfileApplicationFile().getLocation().toString())) continue;
            return null;
        }
        return pam.loadProfileApplication(profileApplicationFile);
    }

    @Override
    public void unloadProfileApplicationForModel(String modelId, ProfileApplicationDecorator profileApplication) {
        if (this.modelledResourceProfilesApplicationsManagerMap.containsKey(modelId)) {
            ProfileApplicationManager pam = this.modelledResourceProfilesApplicationsManagerMap.get(modelId);
            pam.removeProfileApplication(profileApplication);
        }
    }

    @Override
    public void unloadAllProfileApplicationsForModel(String modelId) {
        if (this.modelledResourceProfilesApplicationsManagerMap.containsKey(modelId)) {
            ProfileApplicationManager pam = this.modelledResourceProfilesApplicationsManagerMap.get(modelId);
            pam.dispose();
            this.modelledResourceProfilesApplicationsManagerMap.remove(modelId);
        }
    }

    @Override
    public boolean hasProfileApplications(String modelId) {
        if (this.modelledResourceProfilesApplicationsManagerMap.containsKey(modelId)) {
            ProfileApplicationManager pam = this.modelledResourceProfilesApplicationsManagerMap.get(modelId);
            return pam.hasProfileApplications();
        }
        return false;
    }

    @Override
    public Collection<ProfileApplicationDecorator> getProfileApplications(String modelId) {
        if (modelId == null || !this.hasProfileApplications(modelId)) {
            return Collections.emptyList();
        }
        ProfileApplicationManager pam = this.modelledResourceProfilesApplicationsManagerMap.get(modelId);
        return pam.getProfileApplications();
    }

    @Override
    public ProfileApplicationDecorator getProfileApplicationDecoratorOfContainedEObject(String modelId, EObject eObject) {
        ProfileApplication profileApplication = null;
        if (eObject instanceof ProfileApplication) {
            profileApplication = (ProfileApplication)eObject;
        } else {
            EObject parent = eObject.eContainer();
            while (parent != null) {
                if (parent instanceof ProfileApplication) {
                    profileApplication = (ProfileApplication)parent;
                    break;
                }
                if (parent.eContainer() == null) {
                    return null;
                }
                parent = parent.eContainer();
            }
        }
        ProfileApplicationManager pam = this.modelledResourceProfilesApplicationsManagerMap.get(modelId);
        for (ProfileApplicationDecorator pad : pam.getProfileApplications()) {
            if (!((ProfileApplicationDecoratorImpl)pad).getProfileApplication().equals(profileApplication)) continue;
            return pad;
        }
        return null;
    }
}

