/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofile.diagram.layout;

import org.eclipse.draw2d.AbstractBackground;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.ui.figures.DiagramColorConstants;
import org.eclipse.gmf.runtime.draw2d.ui.figures.DropShadowBorder;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IPolygonAnchorableFigure;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.swt.graphics.Color;

public class AlphaDropShadowBorder
extends AbstractBackground
implements DropShadowBorder {
    private static final int DEFAULT_SHIFT_VALUE = 1;
    private static final Color SHADOW_COLOR = DiagramColorConstants.diagramDarkGray;
    private static final int DEFAULT_TRANSPARENCY = 65;
    private boolean shouldDrawShadow = true;
    private int shift = 1;

    public void setShouldDrawDropShadow(boolean drawDropShadow) {
        this.shouldDrawShadow = drawDropShadow;
    }

    public boolean shouldDrawDropShadow() {
        return this.shouldDrawShadow;
    }

    public Insets getInsets(IFigure figure) {
        Insets insetsNew = new Insets();
        insetsNew.top = 0;
        insetsNew.left = 0;
        insetsNew.bottom = MapModeUtil.getMapMode((IFigure)figure).DPtoLP(this.shift * 2);
        insetsNew.right = MapModeUtil.getMapMode((IFigure)figure).DPtoLP(this.shift * 2);
        return insetsNew;
    }

    public Insets getTransparentInsets(IFigure figure) {
        Insets insetsNew = new Insets();
        insetsNew.top = 0;
        insetsNew.left = 0;
        insetsNew.bottom = MapModeUtil.getMapMode((IFigure)figure).DPtoLP(this.shift * 2);
        insetsNew.right = MapModeUtil.getMapMode((IFigure)figure).DPtoLP(this.shift * 2);
        return insetsNew;
    }

    public void paintBackground(IFigure figure, Graphics graphics, Insets insets) {
        if (this.shouldDrawDropShadow()) {
            graphics.pushState();
            graphics.setBackgroundColor(SHADOW_COLOR);
            graphics.setAlpha(65);
            if (figure instanceof IPolygonAnchorableFigure) {
                PointList polygonPoints = ((IPolygonAnchorableFigure)figure).getPolygonPoints();
                polygonPoints.translate(this.shift, this.shift);
                graphics.fillPolygon(polygonPoints);
                polygonPoints.translate(this.shift, this.shift);
                graphics.fillPolygon(polygonPoints);
            } else {
                Rectangle bounds = figure.getBounds().getCopy();
                bounds.translate(this.shift, this.shift);
                graphics.fillRoundRectangle(bounds, 0, 0);
                bounds.translate(this.shift, this.shift);
                graphics.fillRoundRectangle(bounds, 0, 0);
            }
            graphics.popState();
        }
    }
}

