/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofile.diagram.part;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.modelversioning.emfprofile.Profile;
import org.modelversioning.emfprofile.diagram.part.EMFProfileDiagramEditorPlugin;
import org.modelversioning.emfprofile.diagram.part.EMFProfileDiagramUpdater;
import org.modelversioning.emfprofile.diagram.part.EMFProfileLinkDescriptor;
import org.modelversioning.emfprofile.diagram.part.EMFProfileNodeDescriptor;
import org.modelversioning.emfprofile.diagram.part.EMFProfileVisualIDRegistry;

public class EMFProfileDiagramContentInitializer {
    private Map myDomain2NotationMap = new HashMap();
    private Collection myLinkDescriptors = new LinkedList();

    public void initDiagramContent(Diagram diagram) {
        if (!"EMFProfile".equals(diagram.getType())) {
            EMFProfileDiagramEditorPlugin.getInstance().logError("Incorrect diagram passed as a parameter: " + diagram.getType());
            return;
        }
        if (!(diagram.getElement() instanceof Profile)) {
            EMFProfileDiagramEditorPlugin.getInstance().logError("Incorrect diagram element specified: " + diagram.getElement() + " instead of Profile");
            return;
        }
        this.createProfile_1000Children((View)diagram);
        this.createLinks(diagram);
    }

    private void createProfile_1000Children(View view) {
        List<EMFProfileNodeDescriptor> childNodeDescriptors = EMFProfileDiagramUpdater.getProfile_1000SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (EMFProfileNodeDescriptor)it.next());
        }
    }

    private void createStereotype_2006Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(EMFProfileDiagramUpdater.getStereotype_2006OutgoingLinks(view));
        this.createStereotypeTaggedValueComp_7008Children((View)this.getCompartment(view, 7008));
    }

    private void createEClass_2002Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(EMFProfileDiagramUpdater.getEClass_2002OutgoingLinks(view));
        this.createEClassAttributes_7004Children((View)this.getCompartment(view, 7004));
        this.createEClassOperations_7005Children((View)this.getCompartment(view, 7005));
    }

    private void createEPackage_2003Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(EMFProfileDiagramUpdater.getEPackage_2003OutgoingLinks(view));
        this.createEPackageContents_7002Children((View)this.getCompartment(view, 7002));
    }

    private void createEEnum_2004Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(EMFProfileDiagramUpdater.getEEnum_2004OutgoingLinks(view));
        this.createEEnumLiterals_7003Children((View)this.getCompartment(view, 7003));
    }

    private void createEDataType_2005Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(EMFProfileDiagramUpdater.getEDataType_2005OutgoingLinks(view));
    }

    private void createEAttribute_3001Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(EMFProfileDiagramUpdater.getEAttribute_3001OutgoingLinks(view));
    }

    private void createEAttribute_3004Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(EMFProfileDiagramUpdater.getEAttribute_3004OutgoingLinks(view));
    }

    private void createEOperation_3005Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(EMFProfileDiagramUpdater.getEOperation_3005OutgoingLinks(view));
    }

    private void createEClass_3002Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(EMFProfileDiagramUpdater.getEClass_3002OutgoingLinks(view));
        this.createEClassAttributes_7006Children((View)this.getCompartment(view, 7006));
        this.createEClassOperations_7007Children((View)this.getCompartment(view, 7007));
    }

    private void createEEnumLiteral_3003Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(EMFProfileDiagramUpdater.getEEnumLiteral_3003OutgoingLinks(view));
    }

    private void createStereotypeTaggedValueComp_7008Children(View view) {
        List<EMFProfileNodeDescriptor> childNodeDescriptors = EMFProfileDiagramUpdater.getStereotypeTaggedValueComp_7008SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (EMFProfileNodeDescriptor)it.next());
        }
    }

    private void createEClassAttributes_7004Children(View view) {
        List<EMFProfileNodeDescriptor> childNodeDescriptors = EMFProfileDiagramUpdater.getEClassAttributes_7004SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (EMFProfileNodeDescriptor)it.next());
        }
    }

    private void createEClassOperations_7005Children(View view) {
        List<EMFProfileNodeDescriptor> childNodeDescriptors = EMFProfileDiagramUpdater.getEClassOperations_7005SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (EMFProfileNodeDescriptor)it.next());
        }
    }

    private void createEPackageContents_7002Children(View view) {
        List<EMFProfileNodeDescriptor> childNodeDescriptors = EMFProfileDiagramUpdater.getEPackageContents_7002SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (EMFProfileNodeDescriptor)it.next());
        }
    }

    private void createEClassAttributes_7006Children(View view) {
        List<EMFProfileNodeDescriptor> childNodeDescriptors = EMFProfileDiagramUpdater.getEClassAttributes_7006SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (EMFProfileNodeDescriptor)it.next());
        }
    }

    private void createEClassOperations_7007Children(View view) {
        List<EMFProfileNodeDescriptor> childNodeDescriptors = EMFProfileDiagramUpdater.getEClassOperations_7007SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (EMFProfileNodeDescriptor)it.next());
        }
    }

    private void createEEnumLiterals_7003Children(View view) {
        List<EMFProfileNodeDescriptor> childNodeDescriptors = EMFProfileDiagramUpdater.getEEnumLiterals_7003SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (EMFProfileNodeDescriptor)it.next());
        }
    }

    private void createNode(View parentView, EMFProfileNodeDescriptor nodeDescriptor) {
        String nodeType = EMFProfileVisualIDRegistry.getType(nodeDescriptor.getVisualID());
        Node node = ViewService.createNode((View)parentView, (EObject)nodeDescriptor.getModelElement(), (String)nodeType, (PreferencesHint)EMFProfileDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
        switch (nodeDescriptor.getVisualID()) {
            case 2006: {
                this.createStereotype_2006Children((View)node);
                return;
            }
            case 2002: {
                this.createEClass_2002Children((View)node);
                return;
            }
            case 2003: {
                this.createEPackage_2003Children((View)node);
                return;
            }
            case 2004: {
                this.createEEnum_2004Children((View)node);
                return;
            }
            case 2005: {
                this.createEDataType_2005Children((View)node);
                return;
            }
            case 3001: {
                this.createEAttribute_3001Children((View)node);
                return;
            }
            case 3004: {
                this.createEAttribute_3004Children((View)node);
                return;
            }
            case 3005: {
                this.createEOperation_3005Children((View)node);
                return;
            }
            case 3002: {
                this.createEClass_3002Children((View)node);
                return;
            }
            case 3003: {
                this.createEEnumLiteral_3003Children((View)node);
                return;
            }
        }
    }

    private void createLinks(Diagram diagram) {
        boolean continueLinkCreation = true;
        while (continueLinkCreation) {
            continueLinkCreation = false;
            LinkedList<EMFProfileLinkDescriptor> additionalDescriptors = new LinkedList<EMFProfileLinkDescriptor>();
            Iterator it = this.myLinkDescriptors.iterator();
            while (it.hasNext()) {
                EMFProfileLinkDescriptor nextLinkDescriptor = (EMFProfileLinkDescriptor)it.next();
                if (!this.myDomain2NotationMap.containsKey(nextLinkDescriptor.getSource()) || !this.myDomain2NotationMap.containsKey(nextLinkDescriptor.getDestination())) continue;
                String linkType = EMFProfileVisualIDRegistry.getType(nextLinkDescriptor.getVisualID());
                Edge edge = ViewService.getInstance().createEdge(nextLinkDescriptor.getSemanticAdapter(), (View)diagram, linkType, -1, true, EMFProfileDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                if (edge == null) continue;
                edge.setSource((View)this.myDomain2NotationMap.get(nextLinkDescriptor.getSource()));
                edge.setTarget((View)this.myDomain2NotationMap.get(nextLinkDescriptor.getDestination()));
                it.remove();
                if (nextLinkDescriptor.getModelElement() != null) {
                    this.myDomain2NotationMap.put(nextLinkDescriptor.getModelElement(), edge);
                }
                continueLinkCreation = true;
                switch (nextLinkDescriptor.getVisualID()) {
                    case 4005: {
                        additionalDescriptors.addAll(EMFProfileDiagramUpdater.getExtension_4005OutgoingLinks((View)edge));
                        break;
                    }
                    case 4003: {
                        additionalDescriptors.addAll(EMFProfileDiagramUpdater.getEReference_4003OutgoingLinks((View)edge));
                    }
                }
            }
            this.myLinkDescriptors.addAll(additionalDescriptors);
        }
    }

    private Node getCompartment(View node, int visualID) {
        String type = EMFProfileVisualIDRegistry.getType(visualID);
        for (View nextView : node.getChildren()) {
            if (!(nextView instanceof Node) || !type.equals(nextView.getType())) continue;
            return (Node)nextView;
        }
        return null;
    }
}

