/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofile.project.ui.wizard;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.modelversioning.emfprofile.Profile;
import org.modelversioning.emfprofile.diagram.part.EMFProfileDiagramEditorUtil;
import org.modelversioning.emfprofile.project.EMFProfileProjectNatureUtil;
import org.modelversioning.emfprofile.project.ui.wizard.ProfileProjectData;

public class NewProfileProjectOperation
extends WorkspaceModifyOperation {
    private static final String BUILD_PROP_FILE_NAME = "build.properties";
    private static final String DEFAULT_VERSION = "1.0.0.qualifier";
    private static final String PDE_PLUGIN_NATURE = "org.eclipse.pde.PluginNature";
    private ProfileProjectData projectData;
    private IProject project;
    private Resource profileDiagramResource;
    private boolean openDiagram;

    public NewProfileProjectOperation(ProfileProjectData projectData) {
        this.projectData = projectData;
        this.project = projectData.getProjectHandle();
        this.openDiagram = true;
    }

    public NewProfileProjectOperation(ProfileProjectData projectData, boolean openDiagram) {
        this.projectData = projectData;
        this.project = projectData.getProjectHandle();
        this.openDiagram = openDiagram;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        monitor.beginTask("Creating new EMF Profile project", 4);
        monitor.subTask("Creating project");
        this.createPDEProject((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        monitor.worked(1);
        monitor.subTask("Create contents");
        this.createContents((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        monitor.worked(1);
        monitor.subTask("Create manifest");
        this.createPluginXml((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        this.configureBinBuildProperties();
        monitor.worked(1);
        if (this.openDiagram) {
            monitor.subTask("Open profile");
            this.openEMFProfileDiagram();
        }
        monitor.worked(1);
    }

    private void createPDEProject(IProgressMonitor monitor) throws CoreException {
        if (!this.project.exists()) {
            if (!Platform.getLocation().equals((Object)this.projectData.getLocationPath())) {
                IProjectDescription desc = this.project.getWorkspace().newProjectDescription(this.project.getName());
                desc.setLocation(this.projectData.getLocationPath());
                this.project.create(desc, monitor);
            } else {
                this.project.create(monitor);
            }
            this.project.open(null);
        }
        this.configureNatures(this.project);
    }

    private void configureNatures(IProject project) throws CoreException {
        if (!project.hasNature(PDE_PLUGIN_NATURE)) {
            this.addPDENature();
        }
        if (!project.hasNature("org.modelversioning.emfprofile.project.nature")) {
            EMFProfileProjectNatureUtil.addNature((IProject)project);
        }
    }

    public void addPDENature() throws CoreException {
        IProjectDescription description = this.project.getDescription();
        String[] natures = description.getNatureIds();
        if (!Arrays.asList(natures).contains(PDE_PLUGIN_NATURE)) {
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 1, natures.length);
            newNatures[0] = PDE_PLUGIN_NATURE;
            description.setNatureIds(newNatures);
            this.project.setDescription(description, null);
        }
    }

    private void createPluginXml(IProgressMonitor monitor) throws CoreException {
        IFile pluginXmlFile = this.project.getFile("plugin.xml");
        if (!pluginXmlFile.exists()) {
            StringBuffer pluginXmlContent = new StringBuffer();
            pluginXmlContent.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            pluginXmlContent.append("<?eclipse version=\"3.4\"?>\n");
            pluginXmlContent.append("<plugin\n");
            pluginXmlContent.append("  id=\"" + this.projectData.getProjectName() + "\"\n");
            pluginXmlContent.append("   name=\"" + this.projectData.getProjectName() + "\"\n");
            pluginXmlContent.append("   version=\"1.0.0.qualifier\"\n");
            pluginXmlContent.append("  provider=\"\">\n");
            pluginXmlContent.append("  <requires>\n");
            pluginXmlContent.append("     <import plugin=\"org.modelversioning.emfprofile\" ");
            pluginXmlContent.append("version=\"1.1.0\" ");
            pluginXmlContent.append("match=\"greaterOrEqual\" ");
            pluginXmlContent.append("export=\"true\"/>\n");
            pluginXmlContent.append("     <import plugin=\"org.modelversioning.emfprofile.registry\" ");
            pluginXmlContent.append("version=\"1.0.0\" ");
            pluginXmlContent.append("match=\"greaterOrEqual\" ");
            pluginXmlContent.append("export=\"true\"/>\n");
            pluginXmlContent.append("  </requires>\n");
            pluginXmlContent.append("  <extension point=\"org.modelversioning.emfprofile.profile\">\n");
            pluginXmlContent.append("     <profile profile_resource=\"profile.emfprofile_diagram\"/>\n");
            pluginXmlContent.append("  </extension>\n");
            pluginXmlContent.append("</plugin>\n");
            ByteArrayInputStream source = new ByteArrayInputStream(pluginXmlContent.toString().getBytes());
            pluginXmlFile.create((InputStream)source, true, monitor);
        }
    }

    private void configureBinBuildProperties() throws CoreException {
        IFile buildPropFile = this.project.getFile(BUILD_PROP_FILE_NAME);
        if (!buildPropFile.exists()) {
            StringBuffer buildPropContent = new StringBuffer();
            buildPropContent.append("bin.includes = ");
            buildPropContent.append("plugin.xml,\\\n");
            buildPropContent.append("               ");
            buildPropContent.append("icons");
            buildPropContent.append("/,\\\n");
            buildPropContent.append("               ");
            buildPropContent.append("profile.emfprofile_diagram\n");
            ByteArrayInputStream source = new ByteArrayInputStream(buildPropContent.toString().getBytes());
            buildPropFile.create((InputStream)source, true, null);
        }
    }

    private void openEMFProfileDiagram() {
        if (this.profileDiagramResource != null) {
            try {
                EMFProfileDiagramEditorUtil.openDiagram((Resource)this.profileDiagramResource);
            }
            catch (PartInitException e) {
                new InvocationTargetException(e);
            }
        }
    }

    protected void createContents(IProgressMonitor monitor) throws CoreException, JavaModelException, InvocationTargetException, InterruptedException {
        this.createIconFolder(monitor, this.project);
        try {
            this.createProfile(monitor, this.project);
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
    }

    private void createIconFolder(IProgressMonitor monitor, IProject project) throws CoreException {
        project.getFolder("icons").create(false, true, (IProgressMonitor)new SubProgressMonitor(monitor, 0));
    }

    private void createProfile(IProgressMonitor monitor, IProject project) throws IOException {
        this.profileDiagramResource = EMFProfileDiagramEditorUtil.createDiagram((URI)EMFProfileProjectNatureUtil.getDefaultProfileDiagramURI((IProject)project), (IProgressMonitor)new SubProgressMonitor(monitor, 0));
        this.setProfileDiagramData();
        this.saveProfileDiagramResource();
    }

    private void saveProfileDiagramResource() throws IOException {
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Resource)this.profileDiagramResource);
        this.profileDiagramResource.save(null);
        ((BasicCommandStack)editingDomain.getCommandStack()).saveIsDone();
    }

    private void setProfileDiagramData() {
        final Profile profile = this.getProfileFromResource();
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Resource)this.profileDiagramResource);
        editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){

            protected void doExecute() {
                profile.setName(NewProfileProjectOperation.this.projectData.getProfileName());
                profile.setNsURI(NewProfileProjectOperation.this.projectData.getProfileNamespace());
            }
        });
    }

    private Profile getProfileFromResource() {
        if (this.profileDiagramResource == null) {
            return null;
        }
        TreeIterator contents = this.profileDiagramResource.getAllContents();
        while (contents.hasNext()) {
            EObject next = (EObject)contents.next();
            if (!(next instanceof Profile)) continue;
            return (Profile)next;
        }
        return null;
    }
}

