/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofile.registry.ui.views;

import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;
import org.modelversioning.emfprofile.registry.IProfileRegistry;
import org.modelversioning.emfprofile.registry.ui.EMFProfileRegistryUIPlugin;
import org.modelversioning.emfprofile.registry.ui.provider.ProfileProviderContentAdapter;
import org.modelversioning.emfprofile.registry.ui.provider.ProfileProviderLabelAdapter;

public class RegisteredProfilesView
extends ViewPart
implements Observer {
    public static final String ID = "org.modelversioning.emfprofile.registry.ui.views.RegisteredProfilesView";
    private TreeViewer viewer;
    private DrillDownAdapter drillDownAdapter;
    private IProfileRegistry profileRegistry = IProfileRegistry.eINSTANCE;

    public RegisteredProfilesView() {
        this.profileRegistry.addObserver((Observer)this);
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        this.drillDownAdapter = new DrillDownAdapter(this.viewer);
        this.viewer.setContentProvider((IContentProvider)new ProfileProviderContentAdapter());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ProfileProviderLabelAdapter());
        this.viewer.setSorter(new ViewerSorter());
        this.viewer.setInput((Object)this.profileRegistry.getRegisteredProfileProviders());
        this.hookContextMenu();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                RegisteredProfilesView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        this.drillDownAdapter.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator("additions"));
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    @Override
    public void update(Observable o, Object arg) {
        this.refreshViewer();
    }

    private void refreshViewer() {
        EMFProfileRegistryUIPlugin.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                RegisteredProfilesView.this.viewer.refresh(true);
            }
        });
    }
}

