/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofileapplication.validation;

import org.eclipse.emf.ecore.EClass;
import org.modelversioning.emfprofile.Extension;
import org.modelversioning.emfprofile.Stereotype;
import org.modelversioning.emfprofileapplication.StereotypeApplication;
import org.modelversioning.emfprofileapplication.validation.InapplicableExtensionApplicationViolation;

public class InapplicableExtensionApplicationConstraintValidator {
    private StereotypeApplication stereotypeApplication;

    public InapplicableExtensionApplicationConstraintValidator(StereotypeApplication stereotypeApplication) {
        this.stereotypeApplication = stereotypeApplication;
    }

    public boolean isViolated() {
        return !this.isUsedExtensionApplicable() || !this.isUsedExtensionUsableByStereotype();
    }

    private boolean isUsedExtensionApplicable() {
        return this.getExtension().isApplicable(this.getBaseObjectClass());
    }

    private boolean isUsedExtensionUsableByStereotype() {
        return this.getStereotype().getApplicableExtensions(this.getBaseObjectClass()).contains((Object)this.getExtension());
    }

    private Extension getExtension() {
        return this.stereotypeApplication.getExtension();
    }

    private EClass getBaseObjectClass() {
        return this.stereotypeApplication.getAppliedTo().eClass();
    }

    private Stereotype getStereotype() {
        return (Stereotype)this.stereotypeApplication.eClass();
    }

    public InapplicableExtensionApplicationViolation createViolation() {
        return new InapplicableExtensionApplicationViolation((Stereotype)this.stereotypeApplication.eClass(), this.stereotypeApplication.getExtension(), this.stereotypeApplication.getAppliedTo());
    }
}

