/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofileapplication.util;

import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.modelversioning.emfprofile.Profile;
import org.modelversioning.emfprofileapplication.ProfileImport;

public class ProfileImportResolver {
    public static Profile resolve(ProfileImport profileImport) {
        if (profileImport.getProfile() != null) {
            return profileImport.getProfile();
        }
        Profile profile = ProfileImportResolver.tryToFindProfile(profileImport, EPackage.Registry.INSTANCE);
        if (profile != null) {
            profileImport.setProfile(profile);
        }
        return profileImport.getProfile();
    }

    public static Profile resolve(ProfileImport profileImport, ResourceSet resourceSet) {
        if (profileImport.getProfile() != null) {
            return profileImport.getProfile();
        }
        Profile profile = ProfileImportResolver.tryToFindProfile(profileImport, resourceSet.getPackageRegistry());
        if (profile != null) {
            profileImport.setProfile(profile);
        } else {
            profile = ProfileImportResolver.resolve(profileImport);
            if (profile != null) {
                profileImport.setProfile(profile);
            }
        }
        return profileImport.getProfile();
    }

    public static void persistProfileImport(ProfileImport profileImport) {
    }

    private static Profile tryToFindProfile(ProfileImport profileImport, EPackage.Registry registry) {
        EPackage ePackage = registry.getEPackage(profileImport.getNsURI());
        if (ePackage != null && ePackage instanceof Profile) {
            return (Profile)ePackage;
        }
        return null;
    }
}

