/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofileapplication.validation;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.modelversioning.emfprofile.Extension;
import org.modelversioning.emfprofileapplication.ProfileApplication;
import org.modelversioning.emfprofileapplication.StereotypeApplication;
import org.modelversioning.emfprofileapplication.validation.UpperBoundConstraintViolation;

public class UpperBoundConstraintValidator {
    private final ProfileApplication profileApplication;
    private EList<UpperBoundConstraintViolation> violations = new BasicEList();

    public UpperBoundConstraintValidator(ProfileApplication profileApplication) {
        this.profileApplication = profileApplication;
    }

    public EList<UpperBoundConstraintViolation> getViolations() {
        this.validateProfileApplication();
        return ECollections.unmodifiableEList(this.violations);
    }

    private void validateProfileApplication() {
        EList<EObject> annotatedObjects = this.profileApplication.getAnnotatedObjects();
        for (EObject annotatedObject : annotatedObjects) {
            this.checkAnnotatedObject(annotatedObject);
        }
    }

    private void checkAnnotatedObject(EObject annotatedObject) {
        EList<StereotypeApplication> stereotypeApplications = this.profileApplication.getStereotypeApplications(annotatedObject);
        for (StereotypeApplication stereotypeApplication : stereotypeApplications) {
            Extension extension = stereotypeApplication.getExtension();
            if (extension.getUpperBound() == -1 || this.isUpperBoundOk(extension, stereotypeApplications)) continue;
            this.addViolatingStereotypeApplication(stereotypeApplication);
        }
    }

    private void addViolatingStereotypeApplication(StereotypeApplication stereotypeApplication) {
        if (!this.alreadyReported(stereotypeApplication)) {
            this.violations.add((Object)new UpperBoundConstraintViolation(stereotypeApplication));
        }
    }

    private boolean alreadyReported(StereotypeApplication stereotypeApplication) {
        for (UpperBoundConstraintViolation violation : this.violations) {
            if (!EcoreUtil.equals((EObject)violation.getExtension(), (EObject)stereotypeApplication.getExtension()) || !EcoreUtil.equals((EObject)violation.getModelObject(), (EObject)stereotypeApplication.getAppliedTo())) continue;
            return true;
        }
        return false;
    }

    private boolean isUpperBoundOk(Extension extension, EList<StereotypeApplication> stereotypeApplications) {
        EList<Extension> usedExtensions = this.extractUsedExtensions(stereotypeApplications, extension);
        return usedExtensions.size() <= extension.getUpperBound();
    }

    private EList<Extension> extractUsedExtensions(EList<StereotypeApplication> stereotypeApplications, Extension extension) {
        BasicEList extensions = new BasicEList();
        for (StereotypeApplication stereotypeApplication : stereotypeApplications) {
            if (!this.isSameOrSubsettedExtension(extension, stereotypeApplication)) continue;
            extensions.add((Object)stereotypeApplication.getExtension());
        }
        return extensions;
    }

    private boolean isSameOrSubsettedExtension(Extension extension, StereotypeApplication stereotypeApplication) {
        return extension.equals(stereotypeApplication.getExtension()) || stereotypeApplication.getExtension().getSubsetted().contains((Object)extension);
    }
}

