/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.accuracy.ui.jobs;

import de.uka.ipd.sdq.errorhandling.core.SeverityAndIssue;
import de.uka.ipd.sdq.errorhandling.dialogs.issues.DisplayIssuesDialog;
import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.launchconfig.core.AbstractWorkflowBasedRunConfiguration;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.palladiosimulator.analyzer.workflow.core.jobs.IIssueReceiver;

public class ShowAccuracyInfluenceAnalysisErrorsJob
implements IJob,
IIssueReceiver {
    private static final Logger LOGGER = Logger.getLogger(ShowAccuracyInfluenceAnalysisErrorsJob.class);
    private final AbstractWorkflowBasedRunConfiguration configuration;
    private final List<SeverityAndIssue> issues;

    public ShowAccuracyInfluenceAnalysisErrorsJob(AbstractWorkflowBasedRunConfiguration configuration) {
        this.configuration = configuration;
        this.issues = new ArrayList<SeverityAndIssue>();
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        if (this.issues.size() > 0) {
            LOGGER.warn((Object)"Found validation problems in the models");
            this.displayValidationErrors(this.issues);
            LOGGER.warn((Object)"Continuing workflow, ignoring model validation issues");
        }
    }

    public String getName() {
        return "Show accuracy influence analysis errors";
    }

    public void cleanup(IProgressMonitor monitor) throws CleanupFailedException {
    }

    private void displayValidationErrors(List<SeverityAndIssue> overallResult) throws UserCanceledException {
        if (this.configuration.isInteractive()) {
            DisplayIssuesDialog runner = new DisplayIssuesDialog(overallResult);
            DisplayIssuesDialog.showDialogSync((DisplayIssuesDialog)runner);
            if (!runner.shouldProceedAfterErrorDialog()) {
                throw new UserCanceledException();
            }
        }
    }

    public void addIssues(List<SeverityAndIssue> issues) {
        if (issues != null) {
            this.issues.addAll(issues);
        }
    }
}

