/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.accuracy.transformation;

import org.apache.log4j.Logger;
import org.palladiosimulator.analyzer.quality.qualityannotation.ExactlyAsSpecifiedPrecision;
import org.palladiosimulator.analyzer.quality.qualityannotation.LimitedDeviationPrecision;
import org.palladiosimulator.analyzer.quality.qualityannotation.NoPrecision;
import org.palladiosimulator.analyzer.quality.qualityannotation.Precision;
import org.palladiosimulator.analyzer.quality.qualityannotation.util.QualityAnnotationSwitch;
import org.palladiosimulator.analyzer.quality.util.StoExHelper;
import org.palladiosimulator.pcm.core.PCMRandomVariable;

public class PCMRandomVariableSpecificationAccuracyMinimumTrafo
extends QualityAnnotationSwitch<Boolean> {
    private static final Logger LOGGER = Logger.getLogger(PCMRandomVariableSpecificationAccuracyMinimumTrafo.class);
    private PCMRandomVariable modifiedVariable;
    private String lowerLimit;

    public void setLowerLimit(String lowerLimit) {
        this.lowerLimit = lowerLimit;
    }

    public void setModifiedVariable(PCMRandomVariable modifiedVariable) {
        this.modifiedVariable = modifiedVariable;
    }

    public Boolean caseNoPrecision(NoPrecision object) {
        this.checkModifiedVariable();
        if (this.lowerLimit == null) {
            String msg = "Dynamic type inference of specifications to determine minimal value is not implemented (yet).";
            LOGGER.error((Object)msg);
            throw new IllegalArgumentException(msg);
        }
        this.modifiedVariable.setSpecification(this.lowerLimit);
        this.reset();
        return true;
    }

    public Boolean caseExactlyAsSpecifiedPrecision(ExactlyAsSpecifiedPrecision object) {
        this.checkModifiedVariable();
        this.reset();
        return true;
    }

    public Boolean caseLimitedDeviationPrecision(LimitedDeviationPrecision object) {
        this.checkModifiedVariable();
        String spec = this.modifiedVariable.getSpecification();
        String abs = "" + object.getAbsolute();
        String rel = "" + object.getRelative();
        String min = "MinDeviation(" + spec + ", " + abs + ", " + rel + ")";
        if (this.lowerLimit == null) {
            this.modifiedVariable.setSpecification(min);
        } else {
            this.modifiedVariable.setSpecification(StoExHelper.stoExMax((String)min, (String)this.lowerLimit));
        }
        this.reset();
        return true;
    }

    public Boolean casePrecision(Precision object) {
        this.checkModifiedVariable();
        String msg = "The handling of the provided Precision " + object + " is not implemented.";
        LOGGER.error((Object)msg);
        this.reset();
        throw new IllegalArgumentException(msg);
    }

    private void checkModifiedVariable() {
        if (this.modifiedVariable == null) {
            String msg = "You have to set the modified variable before invoking doSwitch(). Note: The modified variable is reset after an execution of doSwitch() to prevent accidental transformations of the same variable.";
            LOGGER.error((Object)msg);
            throw new IllegalArgumentException(msg);
        }
    }

    private void reset() {
        this.modifiedVariable = null;
        this.lowerLimit = null;
    }
}

