/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.accuracy.transformation;

import de.uka.ipd.sdq.errorhandling.core.SeverityAndIssue;
import de.uka.ipd.sdq.errorhandling.core.SeverityEnum;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.analyzer.accuracy.issues.AccuracyIssueFactory;
import org.palladiosimulator.analyzer.accuracy.jobs.TransformPCMForAccuracyInfluenceAnalysisJob;
import org.palladiosimulator.analyzer.quality.QualityPackage;
import org.palladiosimulator.analyzer.quality.QualityRepository;
import org.palladiosimulator.analyzer.quality.qualityannotation.PCMRECategory;
import org.palladiosimulator.analyzer.quality.qualityannotation.PCMRERequestCategory;
import org.palladiosimulator.analyzer.quality.qualityannotation.PCMServiceSpecification;
import org.palladiosimulator.analyzer.quality.qualityannotation.Precision;
import org.palladiosimulator.analyzer.quality.qualityannotation.QualityAnnotation;
import org.palladiosimulator.analyzer.quality.qualityannotation.QualityAnnotationFactory;
import org.palladiosimulator.analyzer.quality.qualityannotation.REPrecision;
import org.palladiosimulator.analyzer.quality.qualityannotation.RequiredElement;
import org.palladiosimulator.analyzer.quality.util.EMFHelper;
import org.palladiosimulator.analyzer.quality.util.QualityAnnotationLookup;
import org.palladiosimulator.analyzer.workflow.core.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.pcm.seff.AbstractAction;
import org.palladiosimulator.pcm.seff.AbstractBranchTransition;
import org.palladiosimulator.pcm.seff.AbstractInternalControlFlowAction;
import org.palladiosimulator.pcm.seff.AbstractLoopAction;
import org.palladiosimulator.pcm.seff.BranchAction;
import org.palladiosimulator.pcm.seff.ExternalCallAction;
import org.palladiosimulator.pcm.seff.ForkAction;
import org.palladiosimulator.pcm.seff.InternalCallAction;
import org.palladiosimulator.pcm.seff.ResourceDemandingBehaviour;
import org.palladiosimulator.pcm.seff.ResourceDemandingInternalBehaviour;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;
import org.palladiosimulator.pcm.seff.StartAction;
import org.palladiosimulator.pcm.seff.seff_performance.InfrastructureCall;
import org.palladiosimulator.pcm.seff.seff_performance.ParametricResourceDemand;
import org.palladiosimulator.pcm.seff.seff_performance.ResourceCall;
import org.palladiosimulator.pcm.seff.util.SeffSwitch;

public abstract class AbstractAccuracyInfluenceSEFFTransformationStrategy
extends SeffSwitch<Boolean> {
    private static final Logger LOGGER = Logger.getLogger(AbstractAccuracyInfluenceSEFFTransformationStrategy.class);
    private final List<QualityAnnotation> availableQualityAnnotations;
    private QualityAnnotationLookup correspondingQualityLookup;
    private final List<SeverityAndIssue> issues;

    public AbstractAccuracyInfluenceSEFFTransformationStrategy(PCMResourceSetPartition pcmPartition) {
        this.availableQualityAnnotations = this.getQualityAnnotations(pcmPartition);
        this.correspondingQualityLookup = null;
        this.issues = new ArrayList<SeverityAndIssue>();
    }

    public List<SeverityAndIssue> getIssues() {
        return this.issues;
    }

    public Boolean caseResourceDemandingSEFF(ResourceDemandingSEFF object) {
        QualityAnnotation correspondingQuality = this.getQualityAnnotation(object, this.availableQualityAnnotations);
        if (correspondingQuality == null) {
            this.issues.add(AccuracyIssueFactory.createMissingQualityAnnotationIssue((EObject)object));
            correspondingQuality = this.createQualityExactlyAsSpecifiedPrecision();
        } else if (!correspondingQuality.isValid()) {
            this.issues.add(AccuracyIssueFactory.createInvalidQualityAnnotationIssue((EObject)object));
            correspondingQuality = this.createQualityExactlyAsSpecifiedPrecision();
        }
        this.correspondingQualityLookup = new QualityAnnotationLookup(correspondingQuality);
        for (ResourceDemandingInternalBehaviour rdib : object.getResourceDemandingInternalBehaviours()) {
            this.doSwitch((EObject)rdib);
        }
        return this.caseResourceDemandingBehaviour((ResourceDemandingBehaviour)object);
    }

    private QualityAnnotation createQualityExactlyAsSpecifiedPrecision() {
        QualityAnnotation correspondingQuality = QualityAnnotationFactory.eINSTANCE.createQualityAnnotation();
        correspondingQuality.setIsValid(true);
        correspondingQuality.getStipulatedREPrecisions().add((Object)this.createREPrecisionExactlyAsSpecified(PCMRERequestCategory.COMPONENT));
        correspondingQuality.getStipulatedREPrecisions().add((Object)this.createREPrecisionExactlyAsSpecified(PCMRERequestCategory.COMPONENT_INTERNAL));
        correspondingQuality.getStipulatedREPrecisions().add((Object)this.createREPrecisionExactlyAsSpecified(PCMRERequestCategory.INFRASTRUCTURE));
        correspondingQuality.getStipulatedREPrecisions().add((Object)this.createREPrecisionExactlyAsSpecified(PCMRERequestCategory.RESOURCE));
        correspondingQuality.getStipulatedREPrecisions().add((Object)this.createREPrecisionExactlyAsSpecified(PCMRERequestCategory.RESOURCE_DEMAND));
        return correspondingQuality;
    }

    private RequiredElement createREPrecisionExactlyAsSpecified(PCMRERequestCategory category) {
        PCMRECategory re = QualityAnnotationFactory.eINSTANCE.createPCMRECategory();
        re.setCategory(category);
        REPrecision precision = QualityAnnotationFactory.eINSTANCE.createREPrecision();
        precision.setDefaultPrecisionNumberOfCalls((Precision)QualityAnnotationFactory.eINSTANCE.createExactlyAsSpecifiedPrecision());
        if (category == PCMRERequestCategory.RESOURCE_DEMAND) {
            precision.setDefaultPrecisionCallParameter((Precision)QualityAnnotationFactory.eINSTANCE.createNoPrecision());
        } else {
            precision.setDefaultPrecisionCallParameter((Precision)QualityAnnotationFactory.eINSTANCE.createExactlyAsSpecifiedPrecision());
        }
        re.setPrecision(precision);
        return re;
    }

    public Boolean caseResourceDemandingBehaviour(ResourceDemandingBehaviour object) {
        EList steps = object.getSteps_Behaviour();
        StartAction start = (StartAction)EMFHelper.getFirstObjectByType((List)steps, StartAction.class);
        this.doSwitch((EObject)start);
        return true;
    }

    public Boolean caseBranchAction(BranchAction object) {
        for (AbstractBranchTransition abt : object.getBranches_Branch()) {
            this.doSwitch((EObject)abt.getBranchBehaviour_BranchTransition());
        }
        return this.caseAbstractInternalControlFlowAction((AbstractInternalControlFlowAction)object);
    }

    public Boolean caseAbstractLoopAction(AbstractLoopAction object) {
        this.doSwitch((EObject)object.getBodyBehaviour_Loop());
        return this.caseAbstractAction((AbstractAction)object);
    }

    public Boolean caseForkAction(ForkAction object) {
        this.doSwitch((EObject)object.getResourceDemandingBehaviour_AbstractAction());
        return this.caseAbstractInternalControlFlowAction((AbstractInternalControlFlowAction)object);
    }

    public Boolean caseServiceEffectSpecification(ServiceEffectSpecification object) {
        this.correspondingQualityLookup = null;
        String msg = "The provided ServiceEffectSpecification type " + object + " is not supported by the implementation.";
        LOGGER.error((Object)msg);
        this.issues.add(new SeverityAndIssue(SeverityEnum.ERROR, msg, (EObject)object));
        return true;
    }

    public List<QualityAnnotation> getQualityAnnotations(PCMResourceSetPartition pcmPartition) {
        ArrayList<QualityAnnotation> qualityAnnotations = new ArrayList<QualityAnnotation>();
        List qualityRepos = pcmPartition.getElement(QualityPackage.eINSTANCE.getQualityRepository());
        for (QualityRepository qualityRepository : qualityRepos) {
            TransformPCMForAccuracyInfluenceAnalysisJob.addElementsToList(qualityAnnotations, EMFHelper.getObjectsByType((List)qualityRepository.getQualityStatements(), QualityAnnotation.class));
        }
        return qualityAnnotations;
    }

    public QualityAnnotation getQualityAnnotation(ResourceDemandingSEFF rdseff, List<QualityAnnotation> qas) {
        int found = 0;
        QualityAnnotation returnedAnnotation = null;
        for (QualityAnnotation qualityAnnotation : qas) {
            if (!(qualityAnnotation.getForServiceSpecification() instanceof PCMServiceSpecification) || ((PCMServiceSpecification)qualityAnnotation.getForServiceSpecification()).getResourceDemandingSEFF() != rdseff) continue;
            ++found;
            returnedAnnotation = qualityAnnotation;
        }
        if (found > 1) {
            String msg = "There was more than one quality annotation for the RDSEFF with id " + rdseff.getId() + "in basic component " + rdseff.getBasicComponent_ServiceEffectSpecification().getEntityName() + " with id " + rdseff.getBasicComponent_ServiceEffectSpecification().getId() + ". The correct one could not be identified. The annotation with id " + returnedAnnotation.getId() + " is used.";
            LOGGER.warn((Object)msg);
            this.issues.add(new SeverityAndIssue(SeverityEnum.WARNING, msg, (EObject)rdseff));
        }
        return returnedAnnotation;
    }

    public Boolean caseAbstractAction(AbstractAction object) {
        if (object.getSuccessor_AbstractAction() != null) {
            return (Boolean)this.doSwitch((EObject)object.getSuccessor_AbstractAction());
        }
        return true;
    }

    public Boolean caseAbstractInternalControlFlowAction(AbstractInternalControlFlowAction object) {
        REPrecision precision;
        for (InfrastructureCall infrastructureCall : object.getInfrastructureCall__Action()) {
            precision = this.correspondingQualityLookup.getPCMREPrecision(infrastructureCall.getSignature__InfrastructureCall(), infrastructureCall.getRequiredRole__InfrastructureCall());
            this.ensurePrecisionExists(precision);
            this.modifyInfrastructureCall(infrastructureCall, precision);
        }
        for (ResourceCall resourceCall : object.getResourceCall__Action()) {
            precision = this.correspondingQualityLookup.getPCMREPrecision(resourceCall.getSignature__ResourceCall(), resourceCall.getResourceRequiredRole__ResourceCall());
            this.ensurePrecisionExists(precision);
            this.modifyResourceCall(resourceCall, precision);
        }
        for (ParametricResourceDemand demand : object.getResourceDemand_Action()) {
            precision = this.correspondingQualityLookup.getPCMREPrecisionCategoryResourceDemand();
            this.ensurePrecisionExists(precision);
            this.modifyResourceDemand(demand, precision);
        }
        return this.caseAbstractAction((AbstractAction)object);
    }

    public Boolean caseExternalCallAction(ExternalCallAction object) {
        REPrecision precision = this.correspondingQualityLookup.getPCMREPrecision(object.getCalledService_ExternalService(), object.getRole_ExternalService());
        this.ensurePrecisionExists(precision);
        this.modifyComponentExternalCall(object, precision);
        return this.caseAbstractAction((AbstractAction)object);
    }

    public Boolean caseInternalCallAction(InternalCallAction object) {
        REPrecision precision = this.correspondingQualityLookup.getPCMREPrecisionCategoryComponentInternal();
        this.ensurePrecisionExists(precision);
        this.modifyComponentInternalCall(object, precision);
        return this.caseAbstractInternalControlFlowAction((AbstractInternalControlFlowAction)object);
    }

    private void ensurePrecisionExists(REPrecision precision) {
        if (precision == null) {
            String msg = "Could not determine a precision for the SEFF. Make sure a quality annotation exists for each SEFF of the system and that a precision is provided at least for each category.";
            LOGGER.error((Object)"Could not determine a precision for the SEFF. Make sure a quality annotation exists for each SEFF of the system and that a precision is provided at least for each category.");
            throw new IllegalArgumentException("Could not determine a precision for the SEFF. Make sure a quality annotation exists for each SEFF of the system and that a precision is provided at least for each category.");
        }
    }

    protected abstract void modifyInfrastructureCall(InfrastructureCall var1, REPrecision var2);

    protected abstract void modifyResourceCall(ResourceCall var1, REPrecision var2);

    protected abstract void modifyResourceDemand(ParametricResourceDemand var1, REPrecision var2);

    protected abstract void modifyComponentInternalCall(InternalCallAction var1, REPrecision var2);

    protected abstract void modifyComponentExternalCall(ExternalCallAction var1, REPrecision var2);
}

