/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.quality.presentation;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.palladiosimulator.analyzer.quality.qualityannotation.LimitedDeviationPrecision;
import org.palladiosimulator.analyzer.quality.qualityannotation.Precision;
import org.palladiosimulator.analyzer.quality.qualityannotation.QualityAnnotationFactory;

public class PrecisionGroup
implements SelectionListener {
    private String groupName;
    private Text textAbsolute;
    private Text textRelative;
    private Group grp;
    private Button btnNoAccuracy;
    private Button btnExactylAsSpecified;
    private Button btnLimitedDeviationPrecision;
    private final ModifyListener listener;

    PrecisionGroup(String groupName, ModifyListener listener) {
        this.groupName = groupName;
        this.listener = listener;
    }

    public void createGroup(Composite parent) {
        this.grp = new Group(parent, 0);
        this.grp.setText(this.groupName);
        this.grp.setLayout((Layout)new GridLayout(1, false));
        this.btnNoAccuracy = new Button((Composite)this.grp, 16);
        this.btnNoAccuracy.setSelection(true);
        this.btnNoAccuracy.setText("No Precision");
        this.btnExactylAsSpecified = new Button((Composite)this.grp, 16);
        this.btnExactylAsSpecified.setText("Exactly As Specified");
        this.btnLimitedDeviationPrecision = new Button((Composite)this.grp, 16);
        this.btnLimitedDeviationPrecision.addSelectionListener((SelectionListener)this);
        this.btnLimitedDeviationPrecision.setText("Limited Deviation Precision");
        Composite composite = new Composite((Composite)this.grp, 0);
        composite.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        composite.setLayout((Layout)new GridLayout(2, false));
        this.textAbsolute = new Text(composite, 2048);
        this.textAbsolute.setEnabled(false);
        this.textAbsolute.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textAbsolute.setToolTipText("Provide the absolute deviation. This is a value greater or equal to 0.");
        this.textAbsolute.addModifyListener(this.listener);
        Label lblAbsoluteDeviation = new Label(composite, 0);
        lblAbsoluteDeviation.setText("Absolute");
        this.textRelative = new Text(composite, 2048);
        this.textRelative.setEnabled(false);
        this.textRelative.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textRelative.setToolTipText("Provide the relative deviation. This is a value in the interval (0,1].");
        this.textRelative.addModifyListener(this.listener);
        Label lblRelative = new Label(composite, 0);
        lblRelative.setText("Relative");
    }

    public Precision getPrecision() {
        if (this.btnNoAccuracy.getSelection()) {
            return QualityAnnotationFactory.eINSTANCE.createNoPrecision();
        }
        if (this.btnExactylAsSpecified.getSelection()) {
            return QualityAnnotationFactory.eINSTANCE.createExactlyAsSpecifiedPrecision();
        }
        if (this.btnLimitedDeviationPrecision.getSelection()) {
            LimitedDeviationPrecision precision = QualityAnnotationFactory.eINSTANCE.createLimitedDeviationPrecision();
            precision.setAbsolute(new Double(this.textAbsolute.getText()).doubleValue());
            precision.setRelative(new Double(this.textRelative.getText()).doubleValue());
            return precision;
        }
        throw new IllegalStateException("Selection state not know to the implementation.");
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.btnLimitedDeviationPrecision.getSelection()) {
            this.textAbsolute.setEnabled(true);
            this.textRelative.setEnabled(true);
        } else {
            this.textAbsolute.setEnabled(false);
            this.textAbsolute.setText("");
            this.textRelative.setEnabled(false);
            this.textRelative.setText("");
        }
        this.listener.modifyText(null);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public boolean isValid() {
        return this.getErrorMessage() == null;
    }

    public String getErrorMessage() {
        if (this.btnLimitedDeviationPrecision.getSelection()) {
            block10: {
                if (this.textAbsolute.getText().isEmpty()) {
                    return "Enter a value for the absolute precision.";
                }
                if (this.textRelative.getText().isEmpty()) {
                    return "Enter a value for the relative precision.";
                }
                try {
                    Double d = new Double(this.textAbsolute.getText());
                    if (d < 0.0) {
                        return "The absolute precision must be greater or equal to one.";
                    }
                }
                catch (NumberFormatException nfe) {
                    return "Absolute precision is not a number.";
                }
                try {
                    Double d = new Double(this.textRelative.getText());
                    if (!(d <= 0.0)) break block10;
                    return "The relative precision must be greater than 0.";
                }
                catch (NumberFormatException nfe) {
                    return "Relative precision is not a number.";
                }
            }
            Double d = new Double(this.textRelative.getText());
            if (d > 1.0) {
                return "The relative precision must be smaller or equal to 1.";
            }
        }
        return null;
    }

    public void dispose() {
        this.btnLimitedDeviationPrecision.removeSelectionListener((SelectionListener)this);
        this.textAbsolute.removeModifyListener(this.listener);
        this.textRelative.removeModifyListener(this.listener);
    }
}

