/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.quality.presentation;

import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.palladiosimulator.analyzer.quality.QualityFactory;
import org.palladiosimulator.analyzer.quality.QualityRepository;
import org.palladiosimulator.analyzer.quality.presentation.DefaultQualityWizardPage;
import org.palladiosimulator.analyzer.quality.presentation.QualityEditorPlugin;
import org.palladiosimulator.analyzer.quality.presentation.QualityModelWizard;
import org.palladiosimulator.analyzer.quality.presentation.SelectRepositoryWizardPage;
import org.palladiosimulator.analyzer.quality.qualityannotation.PCMRERequestCategory;
import org.palladiosimulator.analyzer.quality.qualityannotation.PCMServiceSpecification;
import org.palladiosimulator.analyzer.quality.qualityannotation.QualityAnnotation;
import org.palladiosimulator.analyzer.quality.qualityannotation.QualityAnnotationFactory;
import org.palladiosimulator.analyzer.quality.qualityannotation.ServiceSpecification;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.InfrastructureRequiredRole;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;

public class DefaultQualityModelWizard
extends QualityModelWizard {
    protected DefaultQualityWizardPage defaultQualityWizardPage;
    protected SelectRepositoryWizardPage selectRepositoryWizardPage;

    @Override
    public void addPages() {
        Object selectedElement;
        this.newFileCreationPage = new QualityModelWizard.QualityModelWizardNewFileCreationPage(this, "Whatever", this.selection);
        this.newFileCreationPage.setTitle(QualityEditorPlugin.INSTANCE.getString("_UI_QualityModelWizard_label"));
        this.newFileCreationPage.setDescription(QualityEditorPlugin.INSTANCE.getString("_UI_QualityModelWizard_description"));
        this.newFileCreationPage.setFileName(String.valueOf(QualityEditorPlugin.INSTANCE.getString("_UI_QualityEditorFilenameDefaultBase")) + "." + (String)FILE_EXTENSIONS.get(0));
        this.addPage((IWizardPage)this.newFileCreationPage);
        if (this.selection != null && !this.selection.isEmpty() && (selectedElement = this.selection.iterator().next()) instanceof IResource) {
            IContainer targetDirectory;
            String defaultModelBaseFilename = QualityEditorPlugin.INSTANCE.getString("_UI_QualityEditorFilenameDefaultBase");
            IResource selectedResource = (IResource)selectedElement;
            if (selectedResource.getType() == 1) {
                targetDirectory = selectedResource.getParent();
                if (selectedResource.getFileExtension().equals("repository")) {
                    defaultModelBaseFilename = ((IFile)selectedResource).getName().substring(0, selectedResource.getName().length() - 1 - selectedResource.getFileExtension().length());
                }
            } else {
                targetDirectory = (IContainer)selectedResource;
            }
            this.newFileCreationPage.setContainerFullPath(targetDirectory.getFullPath());
            String defaultModelFilenameExtension = (String)FILE_EXTENSIONS.get(0);
            String modelFilename = String.valueOf(defaultModelBaseFilename) + "." + defaultModelFilenameExtension;
            int i = 1;
            while (targetDirectory.findMember(modelFilename) != null) {
                modelFilename = String.valueOf(defaultModelBaseFilename) + i + "." + defaultModelFilenameExtension;
                ++i;
            }
            this.newFileCreationPage.setFileName(modelFilename);
        }
        this.defaultQualityWizardPage = new DefaultQualityWizardPage("Select default quality");
        this.addPage((IWizardPage)this.defaultQualityWizardPage);
        this.selectRepositoryWizardPage = new SelectRepositoryWizardPage("Select the repository");
        this.selectRepositoryWizardPage.init(this.selection);
        this.addPage((IWizardPage)this.selectRepositoryWizardPage);
    }

    @Override
    protected EObject createInitialModel() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.getResource(URI.createURI((String)this.selectRepositoryWizardPage.getRepositoryFileUri()), true);
        if (resource.getContents().size() != 1) {
            throw new IllegalStateException("Loaded XMI file must only contain one root element.");
        }
        if (!(resource.getContents().get(0) instanceof Repository)) {
            throw new IllegalStateException("Provided repository file did not contain a repository as root element. Location = " + this.selectRepositoryWizardPage.getRepositoryFileUri());
        }
        Repository repo = (Repository)resource.getContents().get(0);
        QualityRepository qRepo = QualityFactory.eINSTANCE.createQualityRepository();
        for (RepositoryComponent rcomp : repo.getComponents__Repository()) {
            if (!(rcomp instanceof BasicComponent)) continue;
            for (ServiceEffectSpecification seff : ((BasicComponent)rcomp).getServiceEffectSpecifications__BasicComponent()) {
                QualityAnnotation qa = QualityAnnotationFactory.eINSTANCE.createQualityAnnotation();
                qa.setIsValid(true);
                Boolean resourceDemandRECategory = false;
                Boolean internalRECategory = false;
                if (seff instanceof ResourceDemandingSEFF) {
                    resourceDemandRECategory = true;
                    if (((ResourceDemandingSEFF)seff).getResourceDemandingInternalBehaviours().size() > 0) {
                        internalRECategory = true;
                    }
                }
                Boolean resourceRECategory = false;
                if (rcomp.getResourceRequiredRoles__ResourceInterfaceRequiringEntity().size() > 0) {
                    resourceRECategory = true;
                }
                Boolean infrastructureRECategory = false;
                Boolean operationRECategory = false;
                for (RequiredRole requiredRole : rcomp.getRequiredRoles_InterfaceRequiringEntity()) {
                    if (requiredRole instanceof InfrastructureRequiredRole) {
                        infrastructureRECategory = true;
                    }
                    if (!(requiredRole instanceof OperationRequiredRole)) continue;
                    operationRECategory = true;
                }
                PCMServiceSpecification serviceSpec = QualityAnnotationFactory.eINSTANCE.createPCMServiceSpecification();
                serviceSpec.setResourceDemandingSEFF((ResourceDemandingSEFF)seff);
                qa.setForServiceSpecification((ServiceSpecification)serviceSpec);
                if (infrastructureRECategory.booleanValue()) {
                    qa.getStipulatedREPrecisions().add((Object)this.defaultQualityWizardPage.getRequiredElement(PCMRERequestCategory.INFRASTRUCTURE));
                }
                if (operationRECategory.booleanValue()) {
                    qa.getStipulatedREPrecisions().add((Object)this.defaultQualityWizardPage.getRequiredElement(PCMRERequestCategory.COMPONENT));
                }
                if (resourceRECategory.booleanValue()) {
                    qa.getStipulatedREPrecisions().add((Object)this.defaultQualityWizardPage.getRequiredElement(PCMRERequestCategory.RESOURCE));
                }
                if (resourceDemandRECategory.booleanValue()) {
                    qa.getStipulatedREPrecisions().add((Object)this.defaultQualityWizardPage.getRequiredElement(PCMRERequestCategory.RESOURCE_DEMAND));
                }
                if (internalRECategory.booleanValue()) {
                    qa.getStipulatedREPrecisions().add((Object)this.defaultQualityWizardPage.getRequiredElement(PCMRERequestCategory.COMPONENT_INTERNAL));
                }
                qRepo.getQualityStatements().add((Object)qa);
            }
        }
        return qRepo;
    }

    @Override
    public boolean performFinish() {
        try {
            final IFile modelFile = this.getModelFile();
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor progressMonitor) {
                    try {
                        try {
                            ResourceSetImpl resourceSet = new ResourceSetImpl();
                            URI fileURI = URI.createPlatformResourceURI((String)modelFile.getFullPath().toString(), (boolean)true);
                            Resource resource = resourceSet.createResource(fileURI);
                            EObject rootObject = DefaultQualityModelWizard.this.createInitialModel();
                            if (rootObject != null) {
                                resource.getContents().add((Object)rootObject);
                            }
                            HashMap options = new HashMap();
                            resource.save(options);
                        }
                        catch (Exception exception) {
                            QualityEditorPlugin.INSTANCE.log(exception);
                            progressMonitor.done();
                        }
                    }
                    finally {
                        progressMonitor.done();
                    }
                }
            };
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
            IWorkbenchWindow workbenchWindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = workbenchWindow.getActivePage();
            final IWorkbenchPart activePart = page.getActivePart();
            if (activePart instanceof ISetSelectionTarget) {
                StructuredSelection targetSelection = new StructuredSelection((Object)modelFile);
                this.getShell().getDisplay().asyncExec(new Runnable((ISelection)targetSelection){
                    private final /* synthetic */ ISelection val$targetSelection;
                    {
                        this.val$targetSelection = iSelection;
                    }

                    @Override
                    public void run() {
                        ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                    }
                });
            }
            try {
                page.openEditor((IEditorInput)new FileEditorInput(modelFile), this.workbench.getEditorRegistry().getDefaultEditor(modelFile.getFullPath().toString()).getId());
            }
            catch (PartInitException exception) {
                MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)QualityEditorPlugin.INSTANCE.getString("_UI_OpenEditorError_label"), (String)exception.getMessage());
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            QualityEditorPlugin.INSTANCE.log(exception);
            return false;
        }
    }
}

