/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.workflow.core.configurations;

import de.uka.ipd.sdq.identifier.IdentifierPackage;
import de.uka.ipd.sdq.probfunction.ProbfunctionPackage;
import de.uka.ipd.sdq.stoex.StoexPackage;
import de.uka.ipd.sdq.units.UnitsPackage;
import de.uka.ipd.sdq.workflow.configuration.InvalidWorkflowJobConfigurationException;
import de.uka.ipd.sdq.workflow.launchconfig.core.AbstractWorkflowBasedRunConfiguration;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.palladiosimulator.analyzer.completions.CompletionsPackage;
import org.palladiosimulator.analyzer.workflow.core.jobs.IIssueReceiver;
import org.palladiosimulator.analyzer.workflow.core.runconfig.AccuracyInfluenceAnalysisState;
import org.palladiosimulator.pcm.PcmPackage;
import org.palladiosimulator.pcm.allocation.AllocationPackage;
import org.palladiosimulator.pcm.core.CorePackage;
import org.palladiosimulator.pcm.parameter.ParameterPackage;
import org.palladiosimulator.pcm.qosannotations.qos_reliability.QosReliabilityPackage;
import org.palladiosimulator.pcm.reliability.ReliabilityPackage;
import org.palladiosimulator.pcm.repository.RepositoryPackage;
import org.palladiosimulator.pcm.resourceenvironment.ResourceenvironmentPackage;
import org.palladiosimulator.pcm.resourcetype.ResourcetypePackage;
import org.palladiosimulator.pcm.seff.SeffPackage;
import org.palladiosimulator.pcm.seff.seff_reliability.SeffReliabilityPackage;
import org.palladiosimulator.pcm.system.SystemPackage;
import org.palladiosimulator.pcm.usagemodel.UsagemodelPackage;

public abstract class AbstractPCMWorkflowRunConfiguration
extends AbstractWorkflowBasedRunConfiguration
implements Cloneable {
    private static final Logger LOGGER = Logger.getLogger(AbstractPCMWorkflowRunConfiguration.class);
    public static final EPackage[] PCM_EPACKAGES = new EPackage[]{EcorePackage.eINSTANCE, IdentifierPackage.eINSTANCE, UnitsPackage.eINSTANCE, ProbfunctionPackage.eINSTANCE, PcmPackage.eINSTANCE, SeffPackage.eINSTANCE, RepositoryPackage.eINSTANCE, ParameterPackage.eINSTANCE, UsagemodelPackage.eINSTANCE, SystemPackage.eINSTANCE, ResourcetypePackage.eINSTANCE, ResourceenvironmentPackage.eINSTANCE, AllocationPackage.eINSTANCE, StoexPackage.eINSTANCE, CorePackage.eINSTANCE, CompletionsPackage.eINSTANCE, ReliabilityPackage.eINSTANCE, QosReliabilityPackage.eINSTANCE, SeffReliabilityPackage.eINSTANCE};
    protected String rmiMiddlewareFile;
    protected String eventMiddlewareFile;
    protected List<String> allocationFiles;
    protected String usageModelFile;
    private String baseProjectID = null;
    private List<String> modelPaths = null;
    private String generatedProjectPath = null;
    protected String temporaryDataLocation;
    protected boolean deleteTemporaryDataAfterAnalysis;
    protected boolean accuracyInfluenceAnalysisEnabled;
    protected String accuracyInformationModelFile;
    protected AccuracyInfluenceAnalysisState accuracyInfluenceAnalysisState;
    protected IIssueReceiver accuracyInfluenceIssueReceivingJob;
    protected boolean overwriteWithoutAsking = false;

    public IIssueReceiver getAccuracyInfluenceIssueReceivingJob() {
        return this.accuracyInfluenceIssueReceivingJob;
    }

    public void setAccuracyInfluenceIssueReceivingJob(IIssueReceiver accuracyInfluenceIssueReceivingJob) {
        this.accuracyInfluenceIssueReceivingJob = accuracyInfluenceIssueReceivingJob;
    }

    public AccuracyInfluenceAnalysisState getAccuracyInfluenceAnalysisState() {
        return this.accuracyInfluenceAnalysisState;
    }

    public void setAccuracyInfluenceAnalysisState(AccuracyInfluenceAnalysisState accuracyInfluenceAnalysisState) {
        this.accuracyInfluenceAnalysisState = accuracyInfluenceAnalysisState;
    }

    public boolean isDeleteTemporaryDataAfterAnalysis() {
        return this.deleteTemporaryDataAfterAnalysis;
    }

    public void setDeleteTemporaryDataAfterAnalysis(boolean deleteTemporaryDataAfterAnalysis) {
        this.checkFixed();
        this.deleteTemporaryDataAfterAnalysis = deleteTemporaryDataAfterAnalysis;
    }

    public boolean isAccuracyInfluenceAnalysisEnabled() {
        return this.accuracyInfluenceAnalysisEnabled;
    }

    public void setAccuracyInfluenceAnalysisEnabled(boolean enabled) {
        this.checkFixed();
        this.accuracyInfluenceAnalysisEnabled = enabled;
    }

    public String getAccuracyInformationModelFile() {
        return this.accuracyInformationModelFile;
    }

    public void setAccuracyInformationModelFile(String accuracyInformationModelFile) {
        this.checkFixed();
        this.accuracyInformationModelFile = accuracyInformationModelFile;
    }

    public String getStoragePluginID() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.temporaryDataLocation);
        if (this.isAccuracyInfluenceAnalysisEnabled()) {
            sb.append("_" + (Object)((Object)this.accuracyInfluenceAnalysisState));
        }
        return sb.toString();
    }

    public void setStoragePluginID(String pluginID) {
        this.checkFixed();
        this.temporaryDataLocation = pluginID;
    }

    public List<String> getPCMModelFiles() {
        ArrayList<String> files = new ArrayList<String>();
        files.addAll(this.allocationFiles);
        files.add(this.usageModelFile);
        if (this.accuracyInfluenceAnalysisEnabled) {
            files.add(this.accuracyInformationModelFile);
        }
        return files;
    }

    public String getRMIMiddlewareFile() {
        return this.rmiMiddlewareFile;
    }

    public void setRMIMiddlewareFile(String rmiMiddlewareFile) {
        this.checkFixed();
        this.rmiMiddlewareFile = rmiMiddlewareFile;
    }

    public String getEventMiddlewareFile() {
        if (this.eventMiddlewareFile != null) {
            return this.eventMiddlewareFile;
        }
        return "pathmap://PCM_MODELS/default_event_middleware.repository";
    }

    public void setEventMiddlewareFile(String eventMiddlewareFile) {
        this.checkFixed();
        this.eventMiddlewareFile = eventMiddlewareFile;
    }

    public List<String> getAllocationFiles() {
        return this.allocationFiles;
    }

    public void setAllocationFiles(List<String> allocationFile) {
        this.checkFixed();
        this.allocationFiles = allocationFile;
    }

    public String getUsageModelFile() {
        return this.usageModelFile;
    }

    public void setUsageModelFile(String usageModelFile) {
        this.checkFixed();
        this.usageModelFile = usageModelFile;
    }

    public boolean isOverwriteWithoutAsking() {
        return this.overwriteWithoutAsking;
    }

    public void setOverwriteWithoutAsking(boolean overwriteWithoutAsking) {
        this.overwriteWithoutAsking = overwriteWithoutAsking;
    }

    public String getBaseProjectID() {
        return this.baseProjectID;
    }

    public void setBaseProjectID(String baseProjectID) {
        this.baseProjectID = baseProjectID;
    }

    public List<String> getModelPaths() {
        return this.modelPaths;
    }

    public void setModelPaths(List<String> modelPaths) {
        this.modelPaths = modelPaths;
    }

    public String getGeneratedProjectPath() {
        return this.generatedProjectPath;
    }

    public void setGeneratedProjectPath(String generatedProjectPath) {
        this.generatedProjectPath = generatedProjectPath;
    }

    public void validateAndFreeze() throws InvalidWorkflowJobConfigurationException {
        super.validateAndFreeze();
        for (String fileURI : this.getPCMModelFiles()) {
            if (fileURI == null) {
                throw new InvalidWorkflowJobConfigurationException("Workflow configuration is invalid, not all PCM models are set");
            }
            URI uRI = URI.createURI((String)fileURI);
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        AbstractPCMWorkflowRunConfiguration config = (AbstractPCMWorkflowRunConfiguration)super.clone();
        config.accuracyInfluenceAnalysisEnabled = this.accuracyInfluenceAnalysisEnabled;
        config.accuracyInfluenceAnalysisState = this.accuracyInfluenceAnalysisState;
        config.accuracyInformationModelFile = new String(this.accuracyInformationModelFile);
        ArrayList<String> newAllocationFiles = new ArrayList<String>(this.allocationFiles.size());
        for (String allocationFile : this.allocationFiles) {
            newAllocationFiles.add(new String(allocationFile));
        }
        config.allocationFiles = newAllocationFiles;
        config.deleteTemporaryDataAfterAnalysis = this.deleteTemporaryDataAfterAnalysis;
        config.eventMiddlewareFile = new String(this.eventMiddlewareFile);
        config.rmiMiddlewareFile = new String(this.rmiMiddlewareFile);
        config.temporaryDataLocation = new String(this.temporaryDataLocation);
        config.usageModelFile = new String(this.usageModelFile);
        config.accuracyInfluenceIssueReceivingJob = this.accuracyInfluenceIssueReceivingJob;
        return config;
    }

    public AbstractPCMWorkflowRunConfiguration getClone() {
        try {
            return (AbstractPCMWorkflowRunConfiguration)this.clone();
        }
        catch (CloneNotSupportedException e) {
            if (LOGGER.isEnabledFor((Priority)Level.FATAL)) {
                LOGGER.fatal((Object)"Could not clone configuration.", (Throwable)e);
            }
            return null;
        }
    }
}

