/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.workflow.core.runconfig;

public class SensitivityAnalysisConfiguration
implements Cloneable {
    double max;
    double step;
    private String variableURI;
    private double min;
    private int runNo;
    private String shortName;

    public SensitivityAnalysisConfiguration(String shortName, String variableURI, double min, double max, double step) {
        this.shortName = shortName == null || shortName.equals("") ? variableURI : shortName;
        this.variableURI = variableURI;
        this.runNo = 0;
        this.max = max;
        this.min = min;
        this.step = step;
    }

    public double getCurrent() {
        return Math.min(this.min + (double)this.runNo * this.step, this.max);
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public double getStep() {
        return this.step;
    }

    public String getVariable() {
        return this.variableURI;
    }

    public int getRunNo() {
        return this.runNo;
    }

    public SensitivityAnalysisConfiguration getNext() {
        SensitivityAnalysisConfiguration result = new SensitivityAnalysisConfiguration(this.shortName, this.variableURI, this.min, this.max, this.step);
        result.runNo = this.runNo + 1;
        return result;
    }

    public SensitivityAnalysisConfiguration getFirst() {
        return new SensitivityAnalysisConfiguration(this.shortName, this.variableURI, this.min, this.max, this.step);
    }

    public String toString() {
        return String.valueOf(this.shortName) + "(" + this.runNo + ", " + this.getCurrent() + ")";
    }

    public String getShortName() {
        return this.shortName;
    }

    protected Object clone() throws CloneNotSupportedException {
        SensitivityAnalysisConfiguration config = (SensitivityAnalysisConfiguration)super.clone();
        config.max = this.max;
        config.min = this.min;
        config.runNo = this.runNo;
        config.shortName = new String(this.shortName);
        config.step = this.step;
        config.variableURI = new String(this.variableURI);
        return config;
    }

    public SensitivityAnalysisConfiguration getClone() {
        try {
            return (SensitivityAnalysisConfiguration)this.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

