/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.workflow.jobs;

import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.palladiosimulator.analyzer.workflow.core.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.analyzer.workflow.core.configurations.AbstractPCMWorkflowRunConfiguration;
import org.palladiosimulator.analyzer.workflow.jobs.CreatePluginProjectJob;

public class CreateWorkingCopyOfModelsJob
implements IJob,
IBlackboardInteractingJob<MDSDBlackboard> {
    private static final String MODEL_FOLDER = "model";
    private static final Logger LOGGER = Logger.getLogger(CreateWorkingCopyOfModelsJob.class);
    private MDSDBlackboard blackboard = null;
    private final AbstractPCMWorkflowRunConfiguration configuration;

    public CreateWorkingCopyOfModelsJob(AbstractPCMWorkflowRunConfiguration configuration) {
        this.configuration = configuration;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        ArrayList<String> originalModelPaths;
        PCMResourceSetPartition workingCopyPartition;
        block6: {
            IFolder modelFolder = this.getOrCreateModelFolder();
            URI modelFolderURI = URI.createFileURI((String)modelFolder.getLocation().toOSString());
            PCMResourceSetPartition partition = (PCMResourceSetPartition)this.blackboard.getPartition("org.palladiosimulator.pcmmodels.partition");
            ResourceSet resourceSet = partition.getResourceSet();
            workingCopyPartition = new PCMResourceSetPartition();
            ArrayList resourceListToIterate = new ArrayList();
            resourceListToIterate.addAll(resourceSet.getResources());
            originalModelPaths = new ArrayList<String>();
            for (Resource resource : resourceListToIterate) {
                if (resource.getURI().scheme().equals("pathmap")) {
                    workingCopyPartition.setContents(resource.getURI(), (List)resource.getContents());
                    continue;
                }
                URI originalURI = resource.getURI();
                URI newURI = CreateWorkingCopyOfModelsJob.concatenateURIs(modelFolderURI, originalURI);
                if (this.configuration.getBaseProjectID() == null) {
                    String[] splitString = originalURI.toString().split("/");
                    this.configuration.setBaseProjectID(splitString[2]);
                }
                if (originalURI.toString() != null) {
                    originalModelPaths.add(originalURI.toString());
                }
                workingCopyPartition.setContents(newURI, (List)resource.getContents());
            }
            try {
                workingCopyPartition.storeAllResources();
            }
            catch (IOException e) {
                if (!LOGGER.isEnabledFor((Priority)Level.ERROR)) break block6;
                LOGGER.error((Object)"Unable to serialize the working copy of the pcm models.", (Throwable)e);
            }
        }
        this.blackboard.removePartition("org.palladiosimulator.pcmmodels.partition");
        this.blackboard.addPartition("org.palladiosimulator.pcmmodels.partition", (Object)workingCopyPartition);
        this.configuration.setModelPaths(originalModelPaths);
    }

    public static URI concatenateURIs(URI modelFolderURI, URI uri) {
        String[] segments = uri.segments();
        String schemeSegment = uri.scheme();
        URI newURI = modelFolderURI.appendSegment(schemeSegment).appendSegments(segments);
        return newURI;
    }

    private IFolder getOrCreateModelFolder() throws JobFailedException {
        assert (this.configuration != null);
        IProject project = CreatePluginProjectJob.getProject(this.configuration.getStoragePluginID());
        assert (project != null);
        return CreatePluginProjectJob.getOrCreateFolder(project, MODEL_FOLDER);
    }

    public String getName() {
        return "Create working copy of models";
    }

    public void cleanup(IProgressMonitor monitor) throws CleanupFailedException {
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }
}

