/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.workflow.runconfig;

import de.uka.ipd.sdq.workflow.launchconfig.LaunchConfigPlugin;
import de.uka.ipd.sdq.workflow.launchconfig.tabs.TabHelper;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.palladiosimulator.analyzer.workflow.core.ConstantsContainer;
import org.palladiosimulator.analyzer.workflow.runconfig.ProtocomFileNamesInputTab;

public class FileNamesInputTab
extends ProtocomFileNamesInputTab {
    protected Text rmiMiddlewareRepository;
    protected Text eventMiddlewareRepository;

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        this.rmiMiddlewareRepository = new Text(this.container, 2052);
        TabHelper.createFileInputSection((Composite)this.container, (ModifyListener)this.modifyListener, (String)"Middleware Repository File", (String[])ConstantsContainer.REPOSITORY_EXTENSION, (Text)this.rmiMiddlewareRepository, (String)"Select Middleware Repository File", (Shell)this.getShell(), (String)"pathmap://PCM_MODELS/Glassfish.repository");
        this.eventMiddlewareRepository = new Text(this.container, 2052);
        TabHelper.createFileInputSection((Composite)this.container, (ModifyListener)this.modifyListener, (String)"Event Middleware Repository File", (String[])ConstantsContainer.REPOSITORY_EXTENSION, (Text)this.eventMiddlewareRepository, (String)"Select Event Middleware Repository File", (Shell)this.getShell(), (String)"pathmap://PCM_MODELS/default_event_middleware.repository");
    }

    @Override
    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        try {
            this.rmiMiddlewareRepository.setText(configuration.getAttribute("rmiRepositoryFile", "pathmap://PCM_MODELS/Glassfish.repository"));
        }
        catch (CoreException e) {
            LaunchConfigPlugin.errorLogger((String)this.getName(), (String)"RMI Middleware Repository File", (String)e.getMessage());
        }
        try {
            this.eventMiddlewareRepository.setText(configuration.getAttribute("eventMiddlewareRepositoryFile", "pathmap://PCM_MODELS/default_event_middleware.repository"));
        }
        catch (CoreException e) {
            LaunchConfigPlugin.errorLogger((String)this.getName(), (String)"Event Middleware Repository File", (String)e.getMessage());
        }
    }

    @Override
    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        configuration.setAttribute("rmiRepositoryFile", this.rmiMiddlewareRepository.getText());
        configuration.setAttribute("eventMiddlewareRepositoryFile", this.eventMiddlewareRepository.getText());
    }

    @Override
    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        super.setDefaults(configuration);
        configuration.setAttribute("rmiRepositoryFile", "pathmap://PCM_MODELS/Glassfish.repository");
        configuration.setAttribute("eventMiddlewareRepositoryFile", "pathmap://PCM_MODELS/default_event_middleware.repository");
    }

    @Override
    public boolean isValid(ILaunchConfiguration launchConfig) {
        boolean tmp = super.isValid(launchConfig);
        if (!TabHelper.validateFilenameExtension((String)this.rmiMiddlewareRepository.getText(), (String[])ConstantsContainer.REPOSITORY_EXTENSION)) {
            this.setErrorMessage("RMI Middleware Repository is missing.");
            return false;
        }
        if (!TabHelper.validateFilenameExtension((String)this.eventMiddlewareRepository.getText(), (String[])ConstantsContainer.REPOSITORY_EXTENSION)) {
            this.setErrorMessage("Event Middleware Repository is missing.");
            return false;
        }
        return tmp;
    }

    @Override
    public String getId() {
        return "de.uka.ipd.sdq.codegen.runconfig.tabs.FileNamesInputTab";
    }
}

