/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.architecturaltemplates.jobs;

import de.uka.ipd.sdq.workflow.extension.AbstractExtensionJobConfiguration;
import de.uka.ipd.sdq.workflow.extension.AbstractWorkflowExtensionJob;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import org.palladiosimulator.architecturaltemplates.jobs.PrepareIsolatedBlackboardPartitionJob;
import org.palladiosimulator.architecturaltemplates.jobs.RunATCompletionJob;
import org.palladiosimulator.architecturaltemplates.jobs.StoreCompletedModelsJob;
import org.palladiosimulator.architecturaltemplates.jobs.ValidateModelsJob;
import org.palladiosimulator.architecturaltemplates.jobs.config.ATExtensionJobConfiguration;

public class RunATJob
extends AbstractWorkflowExtensionJob<MDSDBlackboard> {
    private static final String BEFORE_COMPLETION = "beforeCompletion";
    private static final String AFTER_COMPLETION = "afterCompletion";

    public void setJobConfiguration(AbstractExtensionJobConfiguration jobConfiguration) {
        super.setJobConfiguration(jobConfiguration);
        ATExtensionJobConfiguration configuration = (ATExtensionJobConfiguration)jobConfiguration;
        this.addJob((IJob)new PrepareIsolatedBlackboardPartitionJob(configuration));
        this.addJob((IJob)new ValidateModelsJob(configuration));
        if (configuration.isStoreCompletedModels()) {
            this.addJob((IJob)new StoreCompletedModelsJob(configuration, BEFORE_COMPLETION, true));
        }
        this.addJob((IJob)new RunATCompletionJob(configuration));
        if (configuration.isStoreCompletedModels()) {
            this.addJob((IJob)new StoreCompletedModelsJob(configuration, AFTER_COMPLETION, false));
        }
    }
}

