/*
 * generated by Xtext 2.22.0
 */
package org.palladiosimulator.commons.stoex.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.xtext.validation.Check;
import org.palladiosimulator.commons.stoex.services.StoexContext;
import org.palladiosimulator.commons.stoex.services.StoexContextProvider;

import com.google.inject.Inject;

import de.uka.ipd.sdq.errorhandling.core.IIssue;
import de.uka.ipd.sdq.probfunction.ProbfunctionPackage;
import de.uka.ipd.sdq.stoex.Expression;
import de.uka.ipd.sdq.stoex.StoexPackage;
import de.uka.ipd.sdq.stoex.analyser.exceptions.ExpectedTypeMismatchIssue;
import de.uka.ipd.sdq.stoex.analyser.visitors.ExpressionInferTypeVisitor;
import de.uka.ipd.sdq.stoex.analyser.visitors.NonProbabilisticExpressionInferTypeVisitor;
import de.uka.ipd.sdq.stoex.analyser.visitors.TypeCheckVisitor;
import de.uka.ipd.sdq.stoex.analyser.visitors.TypeEnum;

/**
 * This class contains custom validation rules. 
 *
 * See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#validation
 */
public class StoexValidator extends AbstractStoexValidator {
	
    @Inject
    private StoexContextProvider contextProvider;
    
    @Override
    protected List<EPackage> getEPackages() {
        Set<EPackage> epackages = new HashSet<>(super.getEPackages());
        epackages.add(StoexPackage.eINSTANCE);
        epackages.add(ProbfunctionPackage.eINSTANCE);
        epackages.remove(null);
        return new ArrayList<>(epackages);
    }

    @Check
    public void checkTypes(Expression exp) {
        var typeVisitor = new NonProbabilisticExpressionInferTypeVisitor();
        typeVisitor.doSwitch(exp);
        var typeChecker = new TypeCheckVisitor(typeVisitor);
        typeChecker.doSwitch(exp);
        TreeIterator<EObject> iterator = exp.eAllContents();
        for (; iterator.hasNext();) {
            EObject treeNode = iterator.next();
            typeChecker.doSwitch(treeNode);
        }
        Collection<IIssue> issueList = getIssues(typeChecker);

        for (IIssue ex : issueList) {
            /* TODO: I could not find the following class anymore. If not required anymore, remove. [Krach] */
            /* if (ex instanceof ErrorEntry) {
                error(ex.message, exp, StoexPackage.Literals.IF_ELSE_EXPRESSION__CONDITION_EXPRESSION)
            } else*/ 
            if (ex instanceof ExpectedTypeMismatchIssue) {
                warning(ex.getMessage(), exp, ((ExpectedTypeMismatchIssue)ex).getFeature());
            }
        }

        Optional.ofNullable(exp)
            .map(EObject::eResource)
            .map(contextProvider::getContext)
            .flatMap(StoexContext::getExpectedType)
            .ifPresent(expectedType -> {
                Collection<? extends IIssue> typeIssues = assertType(exp, typeVisitor, expectedType);
                for (IIssue typeIssue : typeIssues) {
                    warning(typeIssue.getMessage(), exp, null);
                }
            });
    }

    protected Collection<IIssue> getIssues(TypeCheckVisitor visitor) {
        return visitor.getIssues();
    }
    
    protected Collection<? extends IIssue> assertType(final EObject result, final ExpressionInferTypeVisitor typeVisitor,
            final TypeEnum expectedType) {
        if (!TypeCheckVisitor.typesCompatible(expectedType, typeVisitor.getType((Expression) result))) {
            return Collections.singletonList(
                    new ExpectedTypeMismatchIssue(expectedType, typeVisitor.getType((Expression) result)));
        }
        return Collections.emptyList();
    }
	
}
