/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.commons.stoex.api.impl.generic;

import de.uka.ipd.sdq.stoex.Expression;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Optional;
import javax.inject.Provider;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.SyntaxErrorMessage;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parser.IParser;
import org.palladiosimulator.commons.stoex.api.impl.generic.GenericStoExParser;

public abstract class GenericStoExParserImpl
implements GenericStoExParser {
    private final IParser parser;

    public GenericStoExParserImpl(Provider<IParser> parserProvider) {
        this.parser = (IParser)parserProvider.get();
    }

    @Override
    public Expression parse(String serializedStoEx) throws ParseException {
        if (serializedStoEx == null || serializedStoEx.isBlank()) {
            throw new ParseException("The given stoex is empty. Therefore it is no valid stoex.", 0);
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (StringReader sr = new StringReader(serializedStoEx);){
            IParseResult result = this.parser.parse((Reader)sr);
            this.assertNoSyntaxErrorException(result);
            return (Expression)result.getRootASTElement();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void assertNoSyntaxErrorException(IParseResult result) throws ParseException {
        if (result == null) {
            throw new ParseException("Unspecified syntax error", 0);
        }
        if (!result.hasSyntaxErrors()) {
            return;
        }
        ArrayList errorMessages = new ArrayList();
        for (INode error : result.getSyntaxErrors()) {
            Optional.ofNullable(error).map(INode::getSyntaxErrorMessage).map(SyntaxErrorMessage::getMessage).ifPresent(errorMessages::add);
        }
        String errorMessage = String.join((CharSequence)System.lineSeparator(), errorMessages);
        throw new ParseException(errorMessage, 0);
    }
}

