/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.commons.eclipseutils;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;

public final class ExtensionHelper {
    private ExtensionHelper() {
    }

    public static List<String> getAttributes(String extensionPointID, String elementName, String attributeName) {
        List<IExtension> extensions = ExtensionHelper.loadExtensions(extensionPointID);
        LinkedList<String> results = new LinkedList<String>();
        for (IExtension extension : extensions) {
            results.add(ExtensionHelper.obtainConfigurationElement(extension, elementName).getAttribute(attributeName));
        }
        return Collections.unmodifiableList(results);
    }

    public static <DATA_TYPE> List<DATA_TYPE> getExecutableExtensions(String extensionPointID, String attributeName) {
        LinkedList<Object> results = new LinkedList<Object>();
        if (Platform.getExtensionRegistry() != null) {
            IConfigurationElement[] configurationElements;
            IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(extensionPointID);
            int n = configurationElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                try {
                    Object executableExtension = configurationElement.createExecutableExtension(attributeName);
                    results.add(executableExtension);
                }
                catch (CoreException e) {
                    throw new RuntimeException("Unable to create executable extension for \"" + extensionPointID + "->" + attributeName + "\"", e);
                }
                ++n2;
            }
        }
        return Collections.unmodifiableList(results);
    }

    public static <DATA_TYPE> DATA_TYPE getExecutableExtension(String extensionPointID, String attributeName, String filterAttributeName, String filterAttributeValue) {
        if (Platform.getExtensionRegistry() != null) {
            IConfigurationElement[] configurationElements;
            IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(extensionPointID);
            int n = configurationElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                if (configurationElement.getAttribute(filterAttributeName).equals(filterAttributeValue)) {
                    try {
                        Object executableExtension = configurationElement.createExecutableExtension(attributeName);
                        return (DATA_TYPE)executableExtension;
                    }
                    catch (CoreException e) {
                        throw new RuntimeException("Unable to create executable extension for \"" + extensionPointID + "->" + attributeName + "\"");
                    }
                }
                ++n2;
            }
        }
        throw new RuntimeException("Unable to create executable extension for \"" + extensionPointID + "->" + attributeName + "\"");
    }

    public static <DATA_TYPE> List<DATA_TYPE> getExecutableExtensions(String extensionPointID, String elementName, String attributeName) {
        LinkedList<Object> results = new LinkedList<Object>();
        List<IExtension> extensions = ExtensionHelper.loadExtensions(extensionPointID);
        for (IExtension extension : extensions) {
            try {
                Object executableExtension = ExtensionHelper.obtainConfigurationElement(extension, elementName).createExecutableExtension(attributeName);
                results.add(executableExtension);
            }
            catch (CoreException e) {
                throw new RuntimeException("Unable to create executable extension for \"" + extensionPointID + "->" + elementName + "->" + attributeName + "\"");
            }
        }
        return Collections.unmodifiableList(results);
    }

    public static <DATA_TYPE> List<DATA_TYPE> getExecutableExtensions(String extensionPointID, String elementName, String attributeName, String filterAttributeName, String filterAttributeValue, Class<DATA_TYPE> extensionType) {
        List<IExtension> extensions = ExtensionHelper.loadExtensions(extensionPointID);
        LinkedList<DATA_TYPE> results = new LinkedList<DATA_TYPE>();
        for (IExtension extension : extensions) {
            IConfigurationElement configurationElement = ExtensionHelper.obtainConfigurationElement(extension, elementName);
            if (!configurationElement.getAttribute(filterAttributeName).equals(filterAttributeValue)) continue;
            try {
                Object ext = configurationElement.createExecutableExtension(attributeName);
                if (!extensionType.isInstance(ext)) continue;
                results.add(extensionType.cast(ext));
            }
            catch (CoreException e) {
                throw new RuntimeException("Could not create executable extension \"" + extensionPointID + "->" + elementName + "->" + attributeName + "\" with filter \"" + filterAttributeName + "\" = \"" + filterAttributeValue + "\"");
            }
        }
        return results;
    }

    public static <DATA_TYPE> DATA_TYPE getExecutableExtension(String extensionPointID, String elementName, String attributeName, String filterAttributeName, String filterAttributeValue, Class<DATA_TYPE> extensionType) {
        List<DATA_TYPE> extensions = ExtensionHelper.getExecutableExtensions(extensionPointID, elementName, attributeName, filterAttributeName, filterAttributeValue, extensionType);
        return (DATA_TYPE)extensions.stream().findAny().orElseThrow(() -> new RuntimeException("Could not create executable extension \"" + extensionPointID + "->" + elementName + "->" + attributeName + "\" with filter \"" + filterAttributeName + "\" = \"" + filterAttributeValue + "\""));
    }

    @Deprecated
    public static <DATA_TYPE> DATA_TYPE getExecutableExtension(String extensionPointID, String elementName, String attributeName, String filterAttributeName, String filterAttributeValue) {
        List<Object> extensions = ExtensionHelper.getExecutableExtensions(extensionPointID, elementName, attributeName, filterAttributeName, filterAttributeValue, Object.class);
        return (DATA_TYPE)extensions.stream().findAny().orElseThrow(() -> new RuntimeException("Could not create executable extension \"" + extensionPointID + "->" + elementName + "->" + attributeName + "\" with filter \"" + filterAttributeName + "\" = \"" + filterAttributeValue + "\""));
    }

    private static IConfigurationElement obtainConfigurationElement(IExtension extension, String elementName) {
        IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals(elementName)) {
                return element;
            }
            ++n2;
        }
        throw new RuntimeException("Could not find extension for element \"" + elementName + "\"");
    }

    private static List<IExtension> loadExtensions(String extensionPointID) {
        return Collections.unmodifiableList(Arrays.asList(Platform.getExtensionRegistry().getExtensionPoint(extensionPointID).getExtensions()));
    }
}

