/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.editors.sirius.assembly.custom.externaljavaactions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.tools.api.ui.IExternalJavaAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.palladiosimulator.editors.commons.dialogs.selection.PalladioSelectEObjectDialog;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.system.System;

public class AddOperationProvidedRole
implements IExternalJavaAction {
    public static final Shell SHELL = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    private static final String NAME_POST_EXTENSION = "ProvidedRole";

    public boolean canExecute(Collection<? extends EObject> arg0) {
        return true;
    }

    public void execute(Collection<? extends EObject> selection, Map<String, Object> parameters) {
        OperationProvidedRole role = (OperationProvidedRole)parameters.get("instance");
        Optional<System> optSystem = selection.stream().filter(System.class::isInstance).map(System.class::cast).findAny();
        OperationInterface oInterface = this.getOperationInterface(role);
        if (optSystem.isPresent()) {
            role.setEntityName(this.findNameOperationProvidedRole(optSystem.get(), oInterface));
        } else {
            role.setEntityName(oInterface.getEntityName());
        }
        role.setProvidedInterface__OperationProvidedRole(oInterface);
    }

    private String findNameOperationProvidedRole(System system, OperationInterface oInterface) {
        String interfaceName;
        String roleName = interfaceName = String.valueOf(oInterface.getEntityName()) + NAME_POST_EXTENSION;
        int i = 1;
        while (this.checkExistingNames(system, roleName)) {
            roleName = String.valueOf(interfaceName) + i;
            if (i == Integer.MAX_VALUE) {
                throw new IllegalStateException("Operation Name Extension too big");
            }
            ++i;
        }
        return roleName;
    }

    private boolean checkExistingNames(System system, String interfaceName) {
        return system.getProvidedRoles_InterfaceProvidingEntity().stream().anyMatch(e -> interfaceName.equals(e.getEntityName()));
    }

    private OperationInterface getOperationInterface(OperationProvidedRole role) {
        ArrayList<Class> filter = new ArrayList<Class>();
        filter.add(Repository.class);
        filter.add(OperationInterface.class);
        ArrayList additionalChildReferences = new ArrayList();
        PalladioSelectEObjectDialog dialog = new PalladioSelectEObjectDialog(SHELL, filter, additionalChildReferences, (Object)role.eResource().getResourceSet());
        dialog.setProvidedService(OperationInterface.class);
        dialog.open();
        return (OperationInterface)dialog.getResult();
    }
}

