/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.editors.sirius.custom.editpart;

import com.google.inject.Injector;
import de.uka.ipd.sdq.stoex.RandomVariable;
import de.uka.ipd.sdq.stoex.analyser.visitors.TypeEnum;
import java.awt.Toolkit;
import java.util.Optional;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.palladiosimulator.editors.sirius.custom.editpart.RandomVariableXtextAdapter;
import org.yakindu.base.xtext.utils.gmf.viewers.XtextStyledTextCellEditorEx;
import org.yakindu.base.xtext.utils.jface.viewers.StyledTextXtextAdapter;
import org.yakindu.base.xtext.utils.jface.viewers.context.IXtextFakeContextResourcesProvider;

public class RandomVariableXtextStyledTextCellEditorEx
extends XtextStyledTextCellEditorEx {
    private final Color errorColor;
    private Color whiteColor;
    private final Optional<RandomVariable> randomVariable;
    private final TypeEnum expectedType;
    private boolean errorDisplayed = false;

    public RandomVariableXtextStyledTextCellEditorEx(int style, Injector injector, Optional<RandomVariable> randomVariable, TypeEnum expectedType) {
        super(style, injector);
        this.expectedType = expectedType;
        this.randomVariable = randomVariable;
        Display display = Display.getCurrent();
        this.errorColor = display.getSystemColor(3);
    }

    protected void focusLost() {
        if (this.getXtextAdapter().getXtextValidationIssues().size() > 0) {
            this.displayError();
        } else {
            super.focusLost();
        }
    }

    private void displayError() {
        Toolkit.getDefaultToolkit().beep();
        this.text.setBackground(this.errorColor);
        this.errorDisplayed = true;
        Display display = Display.getCurrent();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!RandomVariableXtextStyledTextCellEditorEx.this.text.isDisposed()) {
                    RandomVariableXtextStyledTextCellEditorEx.this.text.forceFocus();
                }
            }
        });
    }

    protected void editOccured(ModifyEvent e) {
        if (this.errorDisplayed) {
            this.text.setBackground(this.whiteColor);
            this.errorDisplayed = false;
        }
        super.editOccured(e);
    }

    protected Control createControl(Composite parent) {
        StyledText text = (StyledText)super.createControl(parent);
        text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.character == '\t') {
                    e.doit = false;
                }
            }
        });
        return text;
    }

    protected StyledTextXtextAdapter createXtextAdapter() {
        return new RandomVariableXtextAdapter(this.getInjector(), this.getContextFakeResourceProvider() == null ? IXtextFakeContextResourcesProvider.NULL_CONTEXT_PROVIDER : this.getContextFakeResourceProvider(), this.randomVariable, this.expectedType);
    }
}

