/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.editors.sirius.custom.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.dialect.command.CreateRepresentationCommand;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelection;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelectionCallback;
import org.eclipse.sirius.ui.business.internal.commands.ChangeViewpointSelectionCommand;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class SiriusCustomUtil {
    public static URI getRepresentationsURI(IProject project) {
        return URI.createPlatformResourceURI((String)project.getFullPath().append("/representations.aird").toOSString(), (boolean)true);
    }

    public static void selectViewpoints(Session session, HashSet<Viewpoint> viewpoints, boolean createRepresentation, IProgressMonitor monitor) {
        ViewpointSelectionCallback selectionCallback = new ViewpointSelectionCallback();
        TransactionalEditingDomain domain = session.getTransactionalEditingDomain();
        Collection selectedViewpoints = session.getSelectedViewpoints(false);
        for (Viewpoint v : viewpoints) {
            if (!selectedViewpoints.contains(v)) continue;
            viewpoints.remove(v);
        }
        ChangeViewpointSelectionCommand command = new ChangeViewpointSelectionCommand(session, (ViewpointSelection.Callback)selectionCallback, viewpoints, new HashSet(), createRepresentation, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor));
        domain.getCommandStack().execute((Command)command);
    }

    public static void selectViewpoints(Session session, List<String> viewpointNames, boolean createRepresentation, IProgressMonitor monitor) {
        Set registry = ViewpointRegistry.getInstance().getViewpoints();
        HashSet<Viewpoint> viewpoints = new HashSet<Viewpoint>();
        for (Viewpoint viewpoint : registry) {
            if (!viewpointNames.contains(viewpoint.getName())) continue;
            viewpoints.add(viewpoint);
        }
        SiriusCustomUtil.selectViewpoints(session, viewpoints, createRepresentation, monitor);
    }

    public static DRepresentation createRepresentation(Session session, String representationName, RepresentationDescription description, EObject semantic, IProgressMonitor monitor) {
        TransactionalEditingDomain domain = session.getTransactionalEditingDomain();
        CreateRepresentationCommand createRepresentationCommand = new CreateRepresentationCommand(session, description, semantic, representationName, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor));
        domain.getCommandStack().execute((Command)createRepresentationCommand);
        return createRepresentationCommand.getCreatedRepresentation();
    }

    public static Viewpoint findViewpoint(String viewpointName) {
        Viewpoint viewpoint = null;
        for (Viewpoint v : ViewpointRegistry.getInstance().getViewpoints()) {
            if (!v.getName().equals(viewpointName)) continue;
            viewpoint = v;
        }
        return viewpoint;
    }

    public static Viewpoint getSelectedViewpointByName(Session session, String viewpointName) {
        Viewpoint selectedViewpoint = null;
        Collection selectedViewpoints = session.getSelectedViewpoints(false);
        for (Viewpoint v : selectedViewpoints) {
            if (!viewpointName.equals(v.getName())) continue;
            selectedViewpoint = v;
            break;
        }
        return selectedViewpoint;
    }

    public static RepresentationDescription findDescription(Viewpoint viewpoint, String descriptionName) {
        RepresentationDescription description = null;
        for (RepresentationDescription d : viewpoint.getOwnedRepresentations()) {
            if (!d.getName().equals(descriptionName)) continue;
            description = d;
        }
        return description;
    }

    public static boolean uriAlreadyLoaded(URI uri, Session session) {
        return SiriusCustomUtil.getResourceByURI(uri, session) != null;
    }

    public static Resource getResourceByURI(URI uri, Session session) {
        Collection resources = session.getSemanticResources();
        for (Resource r : resources) {
            if (!r.getURI().equals(uri)) continue;
            return r;
        }
        return null;
    }
}

