/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.editors.sirius.ui.wizard.project;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ui.tools.api.project.ModelingProjectManager;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.palladiosimulator.architecturaltemplates.AT;
import org.palladiosimulator.architecturaltemplates.api.ArchitecturalTemplateAPI;
import org.palladiosimulator.commons.eclipseutils.FileHelper;
import org.palladiosimulator.editors.sirius.custom.util.SiriusCustomUtil;
import org.palladiosimulator.editors.sirius.ui.wizard.project.NewPalladioTemplateWizardPage;

public class NewPalladioProjectWizard
extends Wizard
implements INewWizard {
    private static final String INITIATOR_TEMPLATES_FOLDER = "initiatorTemplates";
    private static final String PERSPECTIVE_ID = "org.palladiosimulator.pcmbench.perspectives.palladio";
    private WizardNewProjectCreationPage projectCreationPage;
    private NewPalladioTemplateWizardPage palladioTemplatePage;
    private IProject project;
    private IConfigurationElement config;
    private IWorkbench workbench;

    public NewPalladioProjectWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
    }

    public void addPages() {
        this.projectCreationPage = new WizardNewProjectCreationPage("NewPalladioProject");
        this.projectCreationPage.setDescription("Create a new Palladio project.");
        this.projectCreationPage.setTitle("New Palladio Project");
        this.addPage((IWizardPage)this.projectCreationPage);
        this.palladioTemplatePage = new NewPalladioTemplateWizardPage(ArchitecturalTemplateAPI.getInitiatorATs());
        this.addPage((IWizardPage)this.palladioTemplatePage);
    }

    public boolean performFinish() {
        boolean confirm;
        final IProject projectHandle = this.projectCreationPage.getProjectHandle();
        java.net.URI projectURI = !this.projectCreationPage.useDefaults() ? this.projectCreationPage.getLocationURI() : null;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProjectDescription desc = workspace.newProjectDescription(projectHandle.getName());
        desc.setLocationURI(projectURI);
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                NewPalladioProjectWizard.this.project = NewPalladioProjectWizard.this.createProject(desc, projectHandle, monitor);
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"An unexpected error occured. See stack trace");
            e.printStackTrace();
            return false;
        }
        if (this.project == null) {
            return false;
        }
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.config);
        BasicNewProjectResourceWizard.selectAndReveal((IResource)this.project, (IWorkbenchWindow)this.workbench.getActiveWorkbenchWindow());
        if (!this.getCurrentPerspectiveId().equals(PERSPECTIVE_ID) && (confirm = MessageDialog.openConfirm((Shell)this.getShell(), (String)"Palladio Perspective", (String)"This project is associated with the Palladio perspective.\n\nDo you want to open this perspective now?"))) {
            this.openPalladioPerspective();
        }
        return true;
    }

    private void openPalladioPerspective() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        try {
            workbench.showPerspective(PERSPECTIVE_ID, window);
        }
        catch (WorkbenchException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Could not open Palladio Perspective");
            e.printStackTrace();
        }
    }

    private String getCurrentPerspectiveId() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        IPerspectiveDescriptor perspective = page.getPerspective();
        return perspective.getId();
    }

    private IProject createProject(IProjectDescription description, IProject projectHandle, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            monitor.beginTask("Creating Project", 8000);
            this.createAndOpenProject(description, projectHandle, SubMonitor.convert((IProgressMonitor)monitor, (String)"Main Task", (int)2000));
            this.handleTemplate(projectHandle, SubMonitor.convert((IProgressMonitor)monitor, (String)"Initializing based on AT", (int)2000));
            this.convertToModelingProject(projectHandle, SubMonitor.convert((IProgressMonitor)monitor, (String)"Converting to Modeling Project", (int)2000));
            this.activateViewpoints(projectHandle, SubMonitor.convert((IProgressMonitor)monitor, (String)"Activating Viewpoints", (int)2000));
        }
        finally {
            monitor.done();
        }
        return projectHandle;
    }

    private void createAndOpenProject(IProjectDescription description, IProject projectHandle, SubMonitor subMonitor) throws CoreException {
        projectHandle.create(description, (IProgressMonitor)subMonitor.split(1000));
        if (subMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        projectHandle.open(128, (IProgressMonitor)subMonitor.split(1000));
    }

    private void handleTemplate(IProject projectHandle, SubMonitor subMonitor) throws CoreException {
        AT selectedTemplate;
        if (this.palladioTemplatePage.getUseTemplate() && (selectedTemplate = this.palladioTemplatePage.getSelectedTemplate()) != null) {
            TemplateInitiationContext context = new TemplateInitiationContext(projectHandle, selectedTemplate);
            context.addToProject(this.computeTemplatePath(selectedTemplate), (IContainer)projectHandle, subMonitor);
        }
    }

    private static String createPlatformUriStart(String projectName) {
        return URI.createPlatformResourceURI((String)projectName, (boolean)false).appendSegment("").toString();
    }

    private URI computeTemplatePath(AT selectedTemplate) {
        URI templateFolderURI = this.getRootURI((EObject)selectedTemplate).appendSegment(INITIATOR_TEMPLATES_FOLDER);
        String[] segments = URI.createURI((String)selectedTemplate.getDefaultInstanceURI()).segments();
        return templateFolderURI.appendSegments(segments);
    }

    private URI getRootURI(EObject eObject) {
        return eObject.eResource().getURI().trimFragment().trimSegments(1);
    }

    private static void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "org.palladiosimulator.editors.sirius.custom.wizard", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    private void convertToModelingProject(IProject projectHandle, SubMonitor subMonitor) throws CoreException {
        ModelingProjectManager.INSTANCE.convertToModelingProject(projectHandle, (IProgressMonitor)subMonitor);
    }

    private void activateViewpoints(IProject projectHandle, SubMonitor subMonitor) {
        URI representationsURI = SiriusCustomUtil.getRepresentationsURI((IProject)projectHandle);
        Session session = SessionManager.INSTANCE.getSession(representationsURI, (IProgressMonitor)subMonitor);
        Set registry = ViewpointRegistry.getInstance().getViewpoints();
        HashSet<Viewpoint> viewpoints = new HashSet<Viewpoint>();
        List<String> extensions = this.getExtensions(session);
        for (Viewpoint viewpoint : registry) {
            String ext = viewpoint.getModelFileExtension();
            if (!extensions.contains(ext)) continue;
            viewpoints.add(viewpoint);
        }
        SiriusCustomUtil.selectViewpoints((Session)session, viewpoints, (boolean)true, (IProgressMonitor)subMonitor);
    }

    private List<String> getExtensions(Session session) {
        ArrayList<String> extensions = new ArrayList<String>();
        for (Resource r : session.getSemanticResources()) {
            if (!r.getClass().getPackage().getName().startsWith("org.palladiosimulator.pcm.") || !r.getURI().isPlatform()) continue;
            extensions.add(r.getURI().fileExtension());
        }
        return extensions;
    }

    private static class TemplateInitiationContext {
        private final IProject projectHandle;
        private final AT template;

        public TemplateInitiationContext(IProject projectHandle, AT template) {
            this.projectHandle = projectHandle;
            this.template = template;
        }

        private void addToProject(URI path, IContainer target, SubMonitor subMonitor) throws CoreException {
            File[] fileArray = FileHelper.getFiles((String)path.toString());
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File source = fileArray[n2];
                Path newTarget = new Path(source.getName());
                if (source.isDirectory()) {
                    this.addFolderToProject(path, source, target.getFolder((IPath)newTarget), subMonitor);
                } else {
                    this.addFileToProject(source, target.getFile((IPath)newTarget), subMonitor);
                }
                ++n2;
            }
        }

        private void addFolderToProject(URI path, File source, IFolder target, SubMonitor subMonitor) throws CoreException {
            if (!target.exists()) {
                target.create(0, true, null);
            }
            this.addToProject(path.appendSegment(source.getName()), (IContainer)target, subMonitor);
        }

        private void addFileToProject(File source, IFile target, SubMonitor subMonitor) throws CoreException {
            try {
                Throwable throwable = null;
                Object var5_9 = null;
                try (InputStream contentStream = this.loadInputFile(source);){
                    if (target.exists()) {
                        target.setContents(contentStream, true, true, (IProgressMonitor)subMonitor);
                    } else {
                        target.create(contentStream, true, (IProgressMonitor)subMonitor);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (FileNotFoundException e) {
                NewPalladioProjectWizard.throwCoreException("File " + source.getAbsolutePath() + " does not exist!");
            }
            catch (IOException e) {
                NewPalladioProjectWizard.throwCoreException("Cannot create input stream on file " + source.getAbsolutePath() + "! " + e.getMessage());
            }
            catch (CoreException e) {
                NewPalladioProjectWizard.throwCoreException(e.getMessage());
            }
        }

        private InputStream loadInputFile(File source) throws IOException {
            if (source.getName().endsWith(".launch")) {
                String fileContent = Files.readString(source.toPath());
                fileContent = fileContent.replace(NewPalladioProjectWizard.createPlatformUriStart(this.template.getEntityName()), NewPalladioProjectWizard.createPlatformUriStart(this.projectHandle.getName()));
                return new ByteArrayInputStream(fileContent.getBytes(StandardCharsets.UTF_8));
            }
            return new FileInputStream(source);
        }
    }
}

