/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.editors.sirius.ui.wizard.model;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.tools.api.command.semantic.AddSemanticResourceCommand;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.tools.api.project.ModelingProjectManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.palladiosimulator.editors.sirius.custom.util.SiriusCustomUtil;
import org.palladiosimulator.editors.sirius.ui.wizard.model.CreateModelCommand;
import org.palladiosimulator.editors.sirius.ui.wizard.model.ModelCreationPage;
import org.palladiosimulator.editors.sirius.ui.wizard.model.RepresentationCreationPage;

public abstract class NewModelWizard
extends Wizard
implements INewWizard {
    private static final String WINDOW_TITLE = "Create Model";
    protected ModelCreationPage modelCreationPage;
    protected RepresentationCreationPage representationCreationPage;
    protected Collection<IWizardPage> additionalPages;
    protected URI modelURI;
    protected EObject modelObject;
    protected Viewpoint viewpoint;
    protected RepresentationDescription representationDescription;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(WINDOW_TITLE);
        this.setNeedsProgressMonitor(true);
        this.representationCreationPage = new RepresentationCreationPage();
        this.additionalPages = new ArrayList<IWizardPage>();
        this.init(selection);
        if (this.viewpoint == null || this.modelObject == null || this.modelCreationPage == null) {
            throw new NullPointerException("Attributes must be correctly initialized in the init method");
        }
    }

    protected abstract void init(IStructuredSelection var1);

    protected void finish() {
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.modelCreationPage);
        this.addPage((IWizardPage)this.representationCreationPage);
        for (IWizardPage page : this.additionalPages) {
            this.addPage(page);
        }
    }

    public boolean performFinish() {
        this.modelURI = this.modelCreationPage.getPlatformURI();
        final boolean createRepresentation = this.representationCreationPage.isRepresentationCreationEnabled();
        final String representationName = this.representationCreationPage.getRepresentationName();
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(URI.decode((String)NewModelWizard.this.modelURI.segment(1)));
                NewModelWizard.this.createModel(project, createRepresentation, representationName, monitor);
                NewModelWizard.this.finish();
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void createModel(IProject project, boolean createRepresentation, String representationName, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Creating Model File", 6000);
        if (!project.hasNature("org.eclipse.sirius.nature.modelingproject")) {
            ModelingProjectManager.INSTANCE.convertToModelingProject(project, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (String)"Converting to Modeling Project", (int)1000));
        }
        URI representationsURI = SiriusCustomUtil.getRepresentationsURI((IProject)project);
        Session session = SessionManager.INSTANCE.getSession(representationsURI, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (String)"Getting Session", (int)1000));
        this.createResource(session, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (String)"Creating Resource", (int)1000));
        HashSet<Viewpoint> selectedViewpoints = new HashSet<Viewpoint>();
        selectedViewpoints.add(this.viewpoint);
        SiriusCustomUtil.selectViewpoints((Session)session, selectedViewpoints, (boolean)false, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (String)"Selecting Viewpoint", (int)1000));
        Viewpoint selectedViewpoint = SiriusCustomUtil.getSelectedViewpointByName((Session)session, (String)this.viewpoint.getName());
        RepresentationDescription actualRepresentationDescription = SiriusCustomUtil.findDescription((Viewpoint)selectedViewpoint, (String)this.representationDescription.getName());
        if (createRepresentation) {
            DRepresentation createdRepresentation = SiriusCustomUtil.createRepresentation((Session)session, (String)representationName, (RepresentationDescription)actualRepresentationDescription, (EObject)this.modelObject, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (String)"Creating Representation", (int)1000));
            DialectUIManager.INSTANCE.openEditor(session, createdRepresentation, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (String)"Opening representation", (int)1000));
        }
        monitor.done();
    }

    private void createResource(Session session, IProgressMonitor monitor) {
        TransactionalEditingDomain domain = session.getTransactionalEditingDomain();
        CreateModelCommand createModelCommand = new CreateModelCommand(domain, this.modelURI, this.modelObject);
        domain.getCommandStack().execute((Command)createModelCommand);
        domain.getCommandStack().execute((Command)new AddSemanticResourceCommand(session, this.modelObject.eResource().getURI(), (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor)));
    }
}

