/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.batchexport;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.measure.Measure;
import org.palladiosimulator.edp2.dao.BinaryMeasurementsDao;
import org.palladiosimulator.edp2.dao.MeasurementsDao;
import org.palladiosimulator.edp2.models.ExperimentData.DataSeries;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentGroup;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentRun;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentSetting;
import org.palladiosimulator.edp2.models.ExperimentData.Measurement;
import org.palladiosimulator.edp2.models.ExperimentData.MeasurementRange;
import org.palladiosimulator.edp2.models.Repository.Repository;
import org.palladiosimulator.edp2.util.MeasurementsUtility;
import org.palladiosimulator.edp2.util.MetricDescriptionUtility;
import org.palladiosimulator.metricspec.BaseMetricDescription;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;

public class BatchExporter {
    private static final char COMMA = ',';
    private static final String NEW_LINE = "\n";

    public static void batchExport(Repository repo, String targetDirectory) {
        for (ExperimentGroup group : repo.getExperimentGroups()) {
            String groupDirectory = String.valueOf(targetDirectory) + File.separator + BatchExporter.removeIllegalChars(String.valueOf(group.getPurpose()) + " " + group.getId()) + File.separator;
            for (ExperimentSetting setting : group.getExperimentSettings()) {
                String settingDirectory = String.valueOf(groupDirectory) + BatchExporter.removeIllegalChars(String.valueOf(setting.getDescription()) + setting.getId()) + File.separator;
                for (ExperimentRun run : setting.getExperimentRuns()) {
                    String runDirectory = String.valueOf(settingDirectory) + BatchExporter.removeIllegalChars(String.valueOf(run.getStartTime().toString()) + " " + run.getId()) + File.separator;
                    for (Measurement measurement : run.getMeasurement()) {
                        BatchExporter.measurementToCsv(runDirectory, measurement);
                    }
                }
            }
        }
    }

    private static void measurementToCsv(String directory, Measurement measurement) {
        BaseMetricDescription[] mds = MetricDescriptionUtility.toBaseMetricDescriptions((MetricDescription)measurement.getMeasuringType().getMetric());
        int timeIdx = 0;
        boolean timeFound = false;
        while (!timeFound && timeIdx < mds.length) {
            if (mds[timeIdx].getId().equals(MetricDescriptionConstants.POINT_IN_TIME_METRIC.getId())) {
                timeFound = true;
                continue;
            }
            ++timeIdx;
        }
        BaseMetricDescription tmp = mds[mds.length - 1];
        mds[mds.length - 1] = MetricDescriptionConstants.POINT_IN_TIME_METRIC;
        mds[timeIdx] = tmp;
        Object dataSeriesList = ((MeasurementRange)measurement.getMeasurementRanges().get(0)).getRawMeasurements().getDataSeries();
        dataSeriesList = new ArrayList(dataSeriesList);
        dataSeriesList.add((DataSeries)dataSeriesList.remove(timeIdx));
        try {
            File file = new File(String.valueOf(directory) + BatchExporter.removeIllegalChars(String.valueOf(measurement.getMeasuringType().getMeasuringPoint().getStringRepresentation()) + " " + measurement.getMeasuringType().getMetric().getName()) + ".csv");
            file.getParentFile().mkdirs();
            FileWriter writer = new FileWriter(file);
            String cols = "";
            List<BaseMetricDescription> metricsList = Arrays.asList(mds);
            Iterator<BaseMetricDescription> metricsIt = metricsList.iterator();
            ArrayList<MeasurementsDao> daos = new ArrayList<MeasurementsDao>();
            Iterator iterator = dataSeriesList.iterator();
            while (iterator.hasNext()) {
                DataSeries series = (DataSeries)iterator.next();
                daos.add(MeasurementsUtility.getMeasurementsDao((DataSeries)series));
            }
            for (MeasurementsDao curDao : daos) {
                BaseMetricDescription curMetricDesc = metricsIt.next();
                cols = String.valueOf(curMetricDesc.getName()) + "[" + ((BinaryMeasurementsDao)curDao).getUnit().toString() + "]" + ',' + cols;
            }
            cols = String.valueOf(cols.substring(0, cols.length() - 1)) + NEW_LINE;
            writer.append(cols);
            long numberOfMsmnts = MeasurementsUtility.getMeasurementsDao((DataSeries)((DataSeries)dataSeriesList.get(0))).getMeasurements().size();
            ArrayList measureIts = new ArrayList();
            for (MeasurementsDao dao : daos) {
                measureIts.add(dao.getMeasurements().iterator());
            }
            int pos = 0;
            while ((long)pos < numberOfMsmnts) {
                String line = "";
                for (Iterator iterator2 : measureIts) {
                    Measure cur = (Measure)iterator2.next();
                    line = String.valueOf(cur.getValue().toString()) + ',' + line;
                }
                line = line.substring(0, line.length() - 1);
                writer.append(String.valueOf(line) + NEW_LINE);
                ++pos;
            }
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String removeIllegalChars(String input) {
        return input.replaceAll("[^a-zA-Z0-9\\._]+", "_");
    }
}

