/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.datastream.chaindescription;

import org.palladiosimulator.edp2.datastream.IDataSource;
import org.palladiosimulator.edp2.datastream.configurable.IPropertyConfigurable;
import org.palladiosimulator.edp2.datastream.filter.AbstractAdapter;

public class ChainDescription {
    private final String chainID;
    private final String chainName;
    private final IDataSource lastChainElement;
    private final IPropertyConfigurable visualization;

    public ChainDescription(String sequenceID, String sequenceName, IDataSource lastDataSource, IPropertyConfigurable visualization) {
        this.chainID = sequenceID;
        this.chainName = sequenceName;
        this.lastChainElement = lastDataSource;
        this.visualization = visualization;
    }

    public String getChainID() {
        return this.chainID;
    }

    public String getChainName() {
        return this.chainName;
    }

    public IPropertyConfigurable getVisualizationInput() {
        return this.visualization;
    }

    public IDataSource attachRootDataSource(IDataSource rootDataSource) {
        if (this.lastChainElement != null) {
            AbstractAdapter current = (AbstractAdapter)this.lastChainElement;
            while (current instanceof AbstractAdapter && current.getDataSource() != null) {
                current = (AbstractAdapter)current.getDataSource();
            }
            current.setDataSource(rootDataSource);
            return this.lastChainElement;
        }
        return rootDataSource;
    }
}

