/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.distancemetrics.ui;

import java.util.logging.Logger;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.palladiosimulator.edp2.datastream.edp2source.Edp2DataTupleDataSource;
import org.palladiosimulator.edp2.visualization.AbstractVisualizationSingleDatastreamInput;
import org.palladiosimulator.edp2.visualization.IVisualisationSingleDatastreamInput;
import org.palladiosimulator.edp2.visualization.properties.sections.InputElementContentProvider;

public class DistanceMetricViewer {
    private static final Logger LOGGER = Logger.getLogger(DistanceMetricViewer.class.getCanonicalName());
    private TableViewer tableViewer;

    public DistanceMetricViewer(Composite composite) {
        this.tableViewer = new TableViewer(composite);
        Table table = this.tableViewer.getTable();
        table.setLayoutData((Object)new GridData(310, 140));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableViewerColumn viewerCol = new TableViewerColumn(this.tableViewer, 0);
        TableColumn column = viewerCol.getColumn();
        column.setText("Description");
        column.setWidth(100);
        viewerCol.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IVisualisationSingleDatastreamInput)element).getInputName();
            }
        });
        TableViewerColumn viewerCol2 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn column2 = viewerCol2.getColumn();
        column2.setText("Metric");
        column2.setWidth(210);
        viewerCol2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IVisualisationSingleDatastreamInput)element).getDataSource().getDataStream().getMetricDesciption().getName().toString();
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)new InputElementContentProvider());
        this.tableViewer.setInput(null);
    }

    public TableViewer getViewer() {
        return this.tableViewer;
    }

    public AbstractVisualizationSingleDatastreamInput getLastSelectedInput() {
        AbstractVisualizationSingleDatastreamInput lastSelectedInput;
        IStructuredSelection selection = this.getViewer().getStructuredSelection();
        if (selection.getFirstElement() instanceof AbstractVisualizationSingleDatastreamInput) {
            lastSelectedInput = (AbstractVisualizationSingleDatastreamInput)selection.getFirstElement();
        } else {
            lastSelectedInput = null;
            LOGGER.warning("Data source could not be selected. Selection is no AbstractVisualizationSingleDatastreamInput.");
        }
        return lastSelectedInput;
    }

    public Edp2DataTupleDataSource getDataSource() {
        AbstractVisualizationSingleDatastreamInput lastSelectedInput = this.getLastSelectedInput();
        Edp2DataTupleDataSource dataSource = null;
        if (lastSelectedInput != null) {
            if (lastSelectedInput.getDataSource() instanceof Edp2DataTupleDataSource) {
                dataSource = (Edp2DataTupleDataSource)lastSelectedInput.getDataSource();
                LOGGER.info(String.valueOf(dataSource.toString()) + " data source selected");
            } else {
                dataSource = null;
                LOGGER.warning("Data source could not be selected. Data source is no Edp2DataTupleDataSource.");
            }
        } else {
            dataSource = null;
            LOGGER.warning("Data source could not be selected. Selection is no AbstractVisualizationSingleDatastreamInput.");
        }
        return dataSource;
    }
}

