/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.distancemetrics.ui.extensions.properties;

import java.util.logging.Logger;
import org.eclipse.nebula.widgets.formattedtext.FormattedText;
import org.eclipse.nebula.widgets.formattedtext.ITextFormatter;
import org.eclipse.nebula.widgets.formattedtext.NumberFormatter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.palladiosimulator.edp2.distancemetrics.EditDistanceOnRealSequence;
import org.palladiosimulator.edp2.distancemetrics.ui.extensions.properties.Format;
import org.palladiosimulator.edp2.distancemetrics.ui.extensions.properties.PropertiesWidget;

public class EditDistanceOnRealSequenceProperties
extends PropertiesWidget {
    private Label epsilonLabel;
    private Text epsilonText;
    private static final Logger LOGGER = Logger.getLogger(EditDistanceOnRealSequenceProperties.class.getCanonicalName());

    public EditDistanceOnRealSequenceProperties(Composite parent, int style, final EditDistanceOnRealSequence edr) {
        super(parent, style);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        this.epsilonLabel = new Label(composite2, 0);
        this.epsilonLabel.setText("Epsilon");
        this.epsilonText = new Text(composite2, 2052);
        this.epsilonText.setText("25");
        this.epsilonText.setSize(50, 10);
        final FormattedText text = new FormattedText(this.epsilonText);
        text.setFormatter((ITextFormatter)new NumberFormatter("##,##0.00", "##,##0.##"));
        GridData data = new GridData();
        data.widthHint = 50;
        text.getControl().setLayoutData((Object)data);
        ModifyListener mlistener = new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                Object value = text.getValue();
                edr.setEpsilon(value != null ? Double.parseDouble(value.toString()) : 25.0);
            }
        };
        Text descriptionText = new Text(composite, 578);
        descriptionText.setEditable(false);
        descriptionText.setLayoutData((Object)new GridData(Format.PROPERTIES_TEXT_WIDTH, Format.PROPERTIES_TEXT_HEIGHT));
        descriptionText.setText("The epsilon value is used to decide, whether two elements are considered equal or not. If the difference of the two considered elements is less than the epsilon value, they are treated equally and their cost is 0. Otherwise the cost is 1. ");
        this.epsilonText.addModifyListener(mlistener);
        LOGGER.info("EditDistanceOnRealSequenceProperties created");
    }
}

