/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.distancemetrics.ui;

import java.util.logging.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.palladiosimulator.edp2.datastream.edp2source.Edp2DataTupleDataSource;
import org.palladiosimulator.edp2.distancemetrics.ui.CalculateButtonListener;
import org.palladiosimulator.edp2.distancemetrics.ui.ComboListener;
import org.palladiosimulator.edp2.distancemetrics.ui.DistanceMetricExtensionHandler;
import org.palladiosimulator.edp2.distancemetrics.ui.DistanceMetricViewer;
import org.palladiosimulator.edp2.distancemetrics.ui.Helper;
import org.palladiosimulator.edp2.distancemetrics.ui.extensions.DistanceMetricExtension;
import org.palladiosimulator.edp2.distancemetrics.ui.extensions.properties.Format;
import org.palladiosimulator.edp2.util.MetricDescriptionUtility;
import org.palladiosimulator.edp2.visualization.AbstractInput;
import org.palladiosimulator.edp2.visualization.AbstractVisualizationSingleDatastreamInput;
import org.palladiosimulator.edp2.visualization.Activator;
import org.palladiosimulator.edp2.visualization.editors.AbstractEditor;
import org.palladiosimulator.metricspec.MetricDescription;

public class DistanceMetricsSection
extends AbstractPropertySection
implements ISelectionChangedListener {
    private static final Logger LOGGER = Logger.getLogger(DistanceMetricsSection.class.getCanonicalName());
    private AbstractEditor<AbstractVisualizationSingleDatastreamInput> editor;
    private Composite composite;
    private Combo comboDropDown;
    private Text resultText;
    private Text descriptionText;
    private Button buttonCalculateDistance;
    private DistanceMetricExtensionHandler dmeHandler;
    private DistanceMetricViewer dmViewer1;
    private DistanceMetricViewer dmViewer2;
    private TabbedPropertySheetPage aTabbedPropertySheetPage;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.composite.setBackground(parent.getDisplay().getSystemColor(22));
        this.initializeDME();
        this.aTabbedPropertySheetPage = aTabbedPropertySheetPage;
        this.createLayout(this.composite);
        this.initializeListeners();
        this.initializeDistanceMetricSelection();
    }

    private void createCombo(Composite composite) {
        this.comboDropDown = Helper.createCombo(composite, this.dmeHandler);
    }

    private void initializeDistanceMetricSelection() {
        if (this.dmeHandler.getDistanceMetricExtensionList().size() != 0) {
            this.comboDropDown.select(0);
            DistanceMetricExtension dme = this.dmeHandler.getDistanceMetricExtensionList().get(0);
            this.descriptionText.setText(dme.getDistanceMetricDescription());
        }
    }

    private void initializeDME() {
        this.dmeHandler = DistanceMetricExtensionHandler.getInstance();
        this.dmeHandler.execute();
        LOGGER.info("Platform running: " + Platform.isRunning());
        LOGGER.info("Extensions loaded.");
    }

    private void initializeListeners() {
        this.initializeButtonListeners(this.buttonCalculateDistance);
        this.initializeComboListeners(this.comboDropDown);
    }

    private void initializeComboListeners(Combo comboDropDown) {
        ComboListener comboListener = new ComboListener(comboDropDown, this.dmeHandler, this.composite, this.aTabbedPropertySheetPage, this.descriptionText);
        comboDropDown.addSelectionListener((SelectionListener)comboListener);
    }

    private void initializeButtonListeners(Button buttonCalculateDistance) {
        CalculateButtonListener btnListener = new CalculateButtonListener(this.dmViewer1, this.dmViewer2, buttonCalculateDistance, this.comboDropDown, this.resultText, this.dmeHandler);
        buttonCalculateDistance.addListener(13, (Listener)btnListener);
    }

    private AbstractInput getInput() {
        AbstractInput result = null;
        if (this.editorExists()) {
            result = (AbstractInput)this.editor.getEditorInput();
        }
        return result;
    }

    public void refresh() {
        this.refreshViewer(this.dmViewer1);
        this.refreshViewer(this.dmViewer2);
        this.composite.layout();
    }

    private void refreshViewer(DistanceMetricViewer dmViewer) {
        if (this.editorExists() && dmViewer.getViewer().getInput() == null) {
            dmViewer.getViewer().setInput((Object)this.getInput());
            dmViewer.getViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        }
        dmViewer.getViewer().refresh();
    }

    private void createLayout(Composite composite) {
        String groupDescription = "Distance Metrics";
        String calculateButtonDescription = "Calculate distance";
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        Group groupDistanceMetrics = new Group(this.composite, 0);
        groupDistanceMetrics.setText("Distance Metrics");
        groupDistanceMetrics.setLayout((Layout)new GridLayout(2, false));
        Composite left = new Composite((Composite)groupDistanceMetrics, 0);
        left.setLayout((Layout)new GridLayout(1, false));
        Composite right = new Composite((Composite)groupDistanceMetrics, 0);
        right.setLayout((Layout)new GridLayout(1, false));
        Composite inputElementComp = new Composite(left, 0);
        inputElementComp.setLayout((Layout)new GridLayout(2, false));
        this.dmViewer1 = new DistanceMetricViewer(inputElementComp);
        this.dmViewer2 = new DistanceMetricViewer(inputElementComp);
        this.createCombo(right);
        GridData gridDataCombo = new GridData();
        gridDataCombo.verticalIndent = 12;
        gridDataCombo.verticalAlignment = 1;
        gridDataCombo.horizontalAlignment = 4;
        gridDataCombo.grabExcessHorizontalSpace = true;
        this.comboDropDown.setLayoutData((Object)gridDataCombo);
        this.descriptionText = new Text(right, 578);
        this.descriptionText.setEditable(false);
        this.descriptionText.setLayoutData((Object)new GridData(Format.PROPERTIES_TEXT_WIDTH, Format.PROPERTIES_TEXT_HEIGHT));
        this.descriptionText.setText("");
        this.buttonCalculateDistance = new Button(left, 8);
        this.buttonCalculateDistance.setAlignment(0x1000040);
        this.buttonCalculateDistance.setText("Calculate distance");
        GridData gridDataCalcDist = new GridData();
        gridDataCalcDist.horizontalAlignment = 2;
        gridDataCalcDist.grabExcessHorizontalSpace = true;
        this.buttonCalculateDistance.setLayoutData((Object)gridDataCalcDist);
        this.resultText = new Text((Composite)groupDistanceMetrics, 2060);
        this.resultText.setText("No result");
        this.resultText.setSize(100, 12);
        GridData gridDataResult = new GridData();
        gridDataResult.horizontalAlignment = 4;
        gridDataResult.grabExcessHorizontalSpace = true;
        this.resultText.setLayoutData((Object)gridDataResult);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        AbstractVisualizationSingleDatastreamInput lastSelectedInput1 = this.dmViewer1.getLastSelectedInput();
        AbstractVisualizationSingleDatastreamInput lastSelectedInput2 = this.dmViewer2.getLastSelectedInput();
        if (lastSelectedInput1 != null && lastSelectedInput2 != null) {
            Edp2DataTupleDataSource dataSource1 = this.dmViewer1.getDataSource();
            Edp2DataTupleDataSource dataSource2 = this.dmViewer2.getDataSource();
            if (dataSource1 != null && dataSource2 != null) {
                boolean isEnabled = MetricDescriptionUtility.metricDescriptionIdsEqual((MetricDescription)dataSource1.getMetricDesciption(), (MetricDescription)dataSource2.getMetricDesciption());
                this.buttonCalculateDistance.setEnabled(isEnabled);
            }
        }
        this.refresh();
    }

    private boolean editorExists() {
        IEditorPart activeEditor;
        IWorkbenchWindow window = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow();
        this.editor = null;
        if (window != null && window.getActivePage() != null && (activeEditor = window.getActivePage().getActiveEditor()) != null) {
            AbstractEditor activeAbstractEditor;
            this.editor = activeAbstractEditor = (AbstractEditor)activeEditor;
        }
        return this.editor != null;
    }
}

