/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.distancemetrics;

import java.util.Iterator;
import javax.measure.quantity.Quantity;
import javax.measure.unit.Unit;
import org.jscience.physics.amount.Amount;
import org.palladiosimulator.edp2.datastream.IDataStream;
import org.palladiosimulator.edp2.distancemetrics.DistanceMetric;
import org.palladiosimulator.edp2.distancemetrics.util.TupleWrapper;
import org.palladiosimulator.edp2.distancemetrics.util.Utility;
import org.palladiosimulator.measurementframework.TupleMeasurement;

public class EuclideanDistance
implements DistanceMetric {
    public Amount<?> calculateDistance(IDataStream<TupleMeasurement> s1, IDataStream<TupleMeasurement> s2) {
        Utility.legalStreamComparison(s1, s2);
        this.init(s1, s2);
        if (DistanceState.numOfElements1 == 0L || DistanceState.numOfElements2 == 0L) {
            DistanceState.finished = true;
        }
        while (!DistanceState.finished) {
            double interpolatedValue;
            TupleWrapper temp;
            if (Utility.compareEquals(DistanceState.c1.getTime(DistanceState.timeBaseUnit), DistanceState.c2.getTime(DistanceState.timeBaseUnit))) {
                DistanceState.sumEucDist += Utility.euclid(DistanceState.c1.getValue(DistanceState.valueBaseUnit), DistanceState.c2.getValue(DistanceState.valueBaseUnit));
                this.skipWhenEqual();
                continue;
            }
            if (DistanceState.c1.getTime(DistanceState.timeBaseUnit) < DistanceState.c2.getTime(DistanceState.timeBaseUnit)) {
                temp = this.skipStream1();
                if (DistanceState.finished) continue;
                if (Utility.compareEquals(DistanceState.c1.getTime(DistanceState.timeBaseUnit), DistanceState.c2.getTime(DistanceState.timeBaseUnit))) {
                    DistanceState.sumEucDist += Utility.euclid(DistanceState.c1.getValue(DistanceState.valueBaseUnit), DistanceState.c2.getValue(DistanceState.valueBaseUnit));
                    this.skipWhenEqual();
                    continue;
                }
                interpolatedValue = this.interpolation(temp, DistanceState.c1, DistanceState.c2);
                DistanceState.sumEucDist += Utility.euclid(interpolatedValue, DistanceState.c2.getValue(DistanceState.valueBaseUnit));
                DistanceState.c2 = this.getNext(DistanceState.it2);
                continue;
            }
            if (!(DistanceState.c2.getTime(DistanceState.timeBaseUnit) < DistanceState.c1.getTime(DistanceState.timeBaseUnit))) continue;
            temp = this.skipStream2();
            if (DistanceState.finished) continue;
            if (Utility.compareEquals(DistanceState.c1.getTime(DistanceState.timeBaseUnit), DistanceState.c2.getTime(DistanceState.timeBaseUnit))) {
                DistanceState.sumEucDist += Utility.euclid(DistanceState.c1.getValue(DistanceState.valueBaseUnit), DistanceState.c2.getValue(DistanceState.valueBaseUnit));
                this.skipWhenEqual();
                continue;
            }
            interpolatedValue = this.interpolation(temp, DistanceState.c2, DistanceState.c1);
            DistanceState.sumEucDist += Utility.euclid(interpolatedValue, DistanceState.c1.getValue(DistanceState.valueBaseUnit));
            DistanceState.c1 = this.getNext(DistanceState.it1);
        }
        return Amount.valueOf((double)DistanceState.sumEucDist, DistanceState.valueBaseUnit);
    }

    private void skipWhenEqual() {
        if (DistanceState.it1.hasNext()) {
            DistanceState.c1 = new TupleWrapper(DistanceState.it1.next());
        } else {
            DistanceState.finished = true;
        }
        if (DistanceState.it2.hasNext()) {
            DistanceState.c2 = new TupleWrapper(DistanceState.it2.next());
        } else {
            DistanceState.finished = true;
        }
    }

    private TupleWrapper skipStream1() {
        TupleWrapper temp = null;
        while (DistanceState.c1.getTime(DistanceState.timeBaseUnit) < DistanceState.c2.getTime(DistanceState.timeBaseUnit) && !DistanceState.finished) {
            temp = DistanceState.c1;
            if (DistanceState.it1.hasNext()) {
                DistanceState.c1 = new TupleWrapper(DistanceState.it1.next());
                continue;
            }
            DistanceState.finished = true;
        }
        return temp;
    }

    private TupleWrapper skipStream2() {
        TupleWrapper temp = null;
        while (DistanceState.c2.getTime(DistanceState.timeBaseUnit) < DistanceState.c1.getTime(DistanceState.timeBaseUnit) && !DistanceState.finished) {
            temp = DistanceState.c2;
            if (DistanceState.it2.hasNext()) {
                DistanceState.c2 = new TupleWrapper(DistanceState.it2.next());
                continue;
            }
            DistanceState.finished = true;
        }
        return temp;
    }

    private double interpolation(TupleWrapper a1, TupleWrapper a2, TupleWrapper b) {
        double[] x = new double[]{a1.getTime(DistanceState.timeBaseUnit), a2.getTime(DistanceState.timeBaseUnit)};
        double[] y = new double[]{a1.getValue(DistanceState.valueBaseUnit), a2.getValue(DistanceState.valueBaseUnit)};
        return Utility.linearInterpolation(x, y, b.getTime(DistanceState.timeBaseUnit));
    }

    private TupleWrapper getNext(Iterator<TupleMeasurement> it) {
        TupleWrapper ret = null;
        if (it.hasNext()) {
            ret = new TupleWrapper(it.next());
        } else {
            DistanceState.finished = true;
        }
        return ret;
    }

    private void init(IDataStream<TupleMeasurement> s1, IDataStream<TupleMeasurement> s2) {
        DistanceState.numOfElements1 = s1.size();
        DistanceState.numOfElements2 = s2.size();
        DistanceState.it1 = s1.iterator();
        DistanceState.it2 = s2.iterator();
        DistanceState.valueBaseUnit = Utility.getBaseValueUnit(s1);
        DistanceState.timeBaseUnit = Utility.getBaseTimeUnit(s1);
        DistanceState.c1 = new TupleWrapper(DistanceState.it1.next());
        DistanceState.c2 = new TupleWrapper(DistanceState.it2.next());
        DistanceState.sumEucDist = 0.0;
        DistanceState.finished = false;
    }

    private static class DistanceState {
        private static Iterator<TupleMeasurement> it1;
        private static Iterator<TupleMeasurement> it2;
        private static Unit<Quantity> valueBaseUnit;
        private static Unit<Quantity> timeBaseUnit;
        private static double sumEucDist;
        private static boolean finished;
        private static TupleWrapper c1;
        private static TupleWrapper c2;
        private static long numOfElements1;
        private static long numOfElements2;

        private DistanceState() {
        }
    }
}

