/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.filter.exponentialsmoothing;

import java.util.ArrayList;
import javax.measure.Measure;
import javax.measure.quantity.Quantity;
import javax.measure.unit.Unit;
import org.palladiosimulator.edp2.datastream.IDataSource;
import org.palladiosimulator.edp2.datastream.filter.AbstractFilter;
import org.palladiosimulator.measurementframework.BasicMeasurement;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.measurementframework.TupleMeasurement;
import org.palladiosimulator.metricspec.BaseMetricDescription;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.MetricSetDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;

public class ExponentialDecayingFilter
extends AbstractFilter {
    private BaseMetricDescription valueMetric;
    Measure<Double, Quantity> average = null;
    MeasuringValue lastTime = null;
    private static double ALPHA = 0.1;
    private static double TAU = -1.0 / Math.log(1.0 - ALPHA);

    public ExponentialDecayingFilter(IDataSource datasource, MetricDescription metricDescription) {
        super(datasource, metricDescription);
        MetricSetDescription set = (MetricSetDescription)this.getMetricDesciption();
        this.valueMetric = (BaseMetricDescription)set.getSubsumedMetrics().stream().filter(m -> !m.getId().equals(MetricDescriptionConstants.POINT_IN_TIME_METRIC.getId())).findAny().get();
    }

    protected MeasuringValue computeOutputFromInput(MeasuringValue next) {
        MeasuringValue curTime = next.getMeasuringValueForMetric((MetricDescription)MetricDescriptionConstants.POINT_IN_TIME_METRIC);
        Measure measuringValue = next.getMeasureForMetric((MetricDescription)this.valueMetric);
        double curTimeVal = (Double)curTime.getMeasureForMetric((MetricDescription)MetricDescriptionConstants.POINT_IN_TIME_METRIC).getValue();
        if (this.average == null || curTimeVal < (Double)this.lastTime.getMeasureForMetric((MetricDescription)MetricDescriptionConstants.POINT_IN_TIME_METRIC).getValue()) {
            this.average = measuringValue;
            this.lastTime = curTime;
            return next;
        }
        Unit unit = measuringValue.getUnit();
        double curValue = measuringValue.doubleValue(unit);
        double oldValue = this.average.doubleValue(unit);
        double lastTimeVal = (Double)this.lastTime.getMeasureForMetric((MetricDescription)MetricDescriptionConstants.POINT_IN_TIME_METRIC).getValue();
        double newEstimateVal = oldValue + (curValue - oldValue) * (1.0 - Math.exp(-(curTimeVal - lastTimeVal) / TAU));
        this.average = Measure.valueOf((double)newEstimateVal, (Unit)unit);
        this.lastTime = curTime;
        BasicMeasurement averageMeasuringValue = new BasicMeasurement(this.average, this.valueMetric);
        ArrayList<Object> result = new ArrayList<Object>(2);
        result.add(curTime);
        result.add(averageMeasuringValue);
        return new TupleMeasurement(result, (MetricSetDescription)this.getMetricDesciption());
    }
}

