/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.repository.local.dao;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.Measure;
import javax.measure.quantity.Quantity;
import javax.measure.unit.Unit;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.io.ExtendedIOUtil;
import org.palladiosimulator.edp2.dao.BinaryMeasurementsDao;
import org.palladiosimulator.edp2.dao.exception.DataNotAccessibleException;
import org.palladiosimulator.edp2.repository.local.dao.FileAccessDao;
import org.palladiosimulator.edp2.repository.local.dao.internal.backgroundlist.BackgroundMemoryList;
import org.palladiosimulator.edp2.repository.local.dao.internal.backgroundlist.BackgroundMemoryListImpl;
import org.palladiosimulator.edp2.repository.local.dao.internal.backgroundlist.serializer.Serializer;

public class FileBinaryMeasurementsDaoImpl<V, Q extends Quantity>
extends FileAccessDao<V, Q>
implements BinaryMeasurementsDao<V, Q> {
    protected static final Logger LOGGER = Logger.getLogger(FileBinaryMeasurementsDaoImpl.class.getCanonicalName());
    private Serializer<V> serializer = null;
    private BackgroundMemoryList<V, Q> backgroundMemoryList;
    private BackgroundMemoryListImpl.BinaryRepresentation binaryRepresentation = null;
    private Unit<Q> unit;

    public void open() throws DataNotAccessibleException {
        super.open();
        if (this.unit == null) {
            String msg = "A unit must be set before a call to open() is made.";
            LOGGER.log(Level.SEVERE, "A unit must be set before a call to open() is made.");
            throw new IllegalStateException("A unit must be set before a call to open() is made.", null);
        }
        if (this.binaryRepresentation == null) {
            String msg = "A binary representation must be set before a call to open() is made.";
            LOGGER.log(Level.SEVERE, "A binary representation must be set before a call to open() is made.");
            throw new IllegalStateException("A binary representation must be set before a call to open() is made.", null);
        }
        if (this.serializer == null) {
            String msg = "Initialization must have failed. Serializer is null.";
            LOGGER.log(Level.SEVERE, "Initialization must have failed. Serializer is null.");
            throw new IllegalStateException("Initialization must have failed. Serializer is null.", null);
        }
        try {
            this.backgroundMemoryList = new BackgroundMemoryListImpl<V, Q>(this.resourceFile.getAbsolutePath(), this.serializer, this.binaryRepresentation, this.unit);
            this.setOpen();
        }
        catch (IOException ioe) {
            String msg = "Error accessing file on background storage.";
            LOGGER.log(Level.SEVERE, "Error accessing file on background storage.", ioe);
            throw new DataNotAccessibleException("Error accessing file on background storage.", (Throwable)ioe);
        }
    }

    public void close() throws DataNotAccessibleException {
        super.close();
        try {
            this.backgroundMemoryList.close();
            this.setClosed();
        }
        catch (IOException ioe) {
            String msg = "Error accessing file on background storage.";
            LOGGER.log(Level.SEVERE, "Error accessing file on background storage.", ioe);
            throw new DataNotAccessibleException("Error accessing file on background storage.", (Throwable)ioe);
        }
    }

    public Serializer<V> getSerializer() {
        return this.serializer;
    }

    public void setSerializer(Serializer<V> serializer) {
        this.serializer = serializer;
    }

    public List<Measure<V, Q>> getMeasurements() {
        if (!this.isOpen()) {
            String msg = "Binary measurements can only be requested if state is open.";
            LOGGER.log(Level.WARNING, "Binary measurements can only be requested if state is open.");
            throw new IllegalStateException("Binary measurements can only be requested if state is open.");
        }
        return this.backgroundMemoryList;
    }

    public BackgroundMemoryListImpl.BinaryRepresentation getBinaryRepresentation() {
        return this.binaryRepresentation;
    }

    public void setBinaryRepresentation(BackgroundMemoryListImpl.BinaryRepresentation binaryRepresentation) {
        if (this.binaryRepresentation != null) {
            String msg = "It is not allowed to set the binary representation more than once.";
            LOGGER.log(Level.SEVERE, "It is not allowed to set the binary representation more than once.");
            throw new IllegalStateException("It is not allowed to set the binary representation more than once.");
        }
        this.binaryRepresentation = binaryRepresentation;
    }

    public Unit<Q> getUnit() {
        return this.unit;
    }

    public void setUnit(Unit<Q> unit) {
        if (this.unit != null) {
            String msg = "It is not allowed to set the unit more than once.";
            LOGGER.log(Level.SEVERE, "It is not allowed to set the unit more than once.");
            throw new IllegalStateException("It is not allowed to set the unit more than once.");
        }
        this.unit = unit;
    }

    @Override
    public synchronized void serialize(ExtendedDataOutputStream output) throws DataNotAccessibleException {
        try {
            super.serialize(output);
            ExtendedIOUtil.writeString((DataOutput)output, (String)this.getUnit().toString());
        }
        catch (IOException e) {
            String msg = "Could not put unit name on stream.";
            LOGGER.log(Level.SEVERE, "Could not put unit name on stream.", e);
            throw new DataNotAccessibleException("Could not put unit name on stream.", (Throwable)e);
        }
    }

    @Override
    public synchronized void deserialize(ExtendedDataInputStream input) throws DataNotAccessibleException {
        try {
            super.deserialize(input);
            this.unit = Unit.valueOf((CharSequence)ExtendedIOUtil.readString((DataInput)input));
        }
        catch (IOException e) {
            String msg = "Could not put unit name on stream.";
            LOGGER.log(Level.SEVERE, "Could not put unit name on stream.", e);
            throw new DataNotAccessibleException("Could not put unit name on stream.", (Throwable)e);
        }
    }

    public void flush() {
        if (this.isOpen()) {
            try {
                this.backgroundMemoryList.flush();
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Flush failed. Data may not be persited", e);
                throw new RuntimeException(e);
            }
        }
    }
}

