/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.repository.local.dao.internal.backgroundlist;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.logging.Logger;
import org.palladiosimulator.edp2.repository.local.dao.internal.backgroundlist.serializer.Serializer;

class ChunkedFile<T> {
    private static final Logger LOGGER = Logger.getLogger(ChunkedFile.class.getName());
    private final RandomAccessFile raf;
    private long loadedChunkFilePos;
    private final Serializer<T> serializer;
    private long elementsInFile;
    private final int chunkSize;
    private T[] data = null;
    private int elementsInLoadedChunk = 0;
    private boolean changed;
    private boolean chunkLoaded;

    public ChunkedFile(RandomAccessFile raf, Serializer<T> serializer, int chunkSize) throws IOException {
        this.raf = raf;
        this.serializer = serializer;
        this.chunkSize = chunkSize;
        this.elementsInFile = raf.length() / serializer.getElementLength();
        this.chunkLoaded = false;
    }

    public void add(T d) {
        if (d == null) {
            String msg = "Chunks do not support null values.";
            LOGGER.severe("Chunks do not support null values.");
            throw new IllegalArgumentException("Chunks do not support null values.");
        }
        if (!this.chunkLoaded) {
            String msg = "Tried to add data element to chunk although there is no chunk loaded.";
            LOGGER.severe("Tried to add data element to chunk although there is no chunk loaded.");
            throw new IllegalStateException("Tried to add data element to chunk although there is no chunk loaded.");
        }
        if (this.isFull()) {
            String msg = "Tried to add data element to chunk without any capacity left.";
            LOGGER.warning("Tried to add data element to chunk without any capacity left.");
            throw new IllegalStateException("Tried to add data element to chunk without any capacity left.");
        }
        this.data[this.elementsInLoadedChunk++] = d;
        this.changed = true;
    }

    public long indexStartingElementForChunk() {
        return this.loadedChunkFilePos / this.serializer.getElementLength();
    }

    public T get(int indexInChunk) {
        if (!this.chunkLoaded) {
            String msg = "Tried to add data element to chunk although there is no chunk loaded.";
            LOGGER.severe("Tried to add data element to chunk although there is no chunk loaded.");
            throw new IllegalStateException("Tried to add data element to chunk although there is no chunk loaded.");
        }
        return this.data[indexInChunk];
    }

    public T set(int indexInChunk, T value) {
        if (value == null) {
            String msg = "Chunks do not support null values.";
            LOGGER.severe("Chunks do not support null values.");
            throw new IllegalArgumentException("Chunks do not support null values.");
        }
        if (!this.chunkLoaded) {
            String msg = "Tried to add data element to chunk although there is no chunk loaded.";
            LOGGER.severe("Tried to add data element to chunk although there is no chunk loaded.");
            throw new IllegalStateException("Tried to add data element to chunk although there is no chunk loaded.");
        }
        T oldElement = this.data[indexInChunk];
        this.data[indexInChunk] = value;
        this.changed = true;
        return oldElement;
    }

    public boolean isFull() {
        return this.elementsInLoadedChunk >= this.chunkSize;
    }

    public void loadChunkForElement(long elementIndex) throws IOException {
        if (this.chunkLoaded && this.changed) {
            String msg = "The currently loaded chunk has been changed but not saved to disc. Cannot load other chunk.";
            LOGGER.severe("The currently loaded chunk has been changed but not saved to disc. Cannot load other chunk.");
            throw new IllegalArgumentException("The currently loaded chunk has been changed but not saved to disc. Cannot load other chunk.");
        }
        long requestedChunkNumber = (long)Math.floor(elementIndex / (long)this.chunkSize);
        long chunkSizeBytes = (long)this.chunkSize * this.serializer.getElementLength();
        this.loadedChunkFilePos = chunkSizeBytes * requestedChunkNumber;
        long lastChunkNumber = (long)Math.floor((this.elementsInFile - 1L) / (long)this.chunkSize);
        int loadedChunkSizeBytes = requestedChunkNumber < lastChunkNumber ? (int)chunkSizeBytes : (requestedChunkNumber == lastChunkNumber ? (int)(this.elementsInFile * this.serializer.getElementLength() - lastChunkNumber * chunkSizeBytes) : 0);
        if (this.loadedChunkFilePos > this.raf.length()) {
            String msg = "The requested element index is not stored in the file.";
            LOGGER.severe("The requested element index is not stored in the file.");
            throw new IllegalArgumentException("The requested element index is not stored in the file.");
        }
        byte[] rawData = new byte[loadedChunkSizeBytes];
        this.raf.seek(this.loadedChunkFilePos);
        this.raf.read(rawData);
        T[] newData = this.serializer.deserialise(rawData);
        if (newData.length == this.chunkSize) {
            this.data = newData;
        } else {
            this.data = new Object[this.chunkSize];
            System.arraycopy(newData, 0, this.data, 0, newData.length);
        }
        this.elementsInLoadedChunk = newData.length;
        this.chunkLoaded = true;
        this.changed = false;
    }

    public void createChunk() {
        if (this.chunkLoaded && this.changed) {
            String msg = "Cannot create chunk if the currently loaded chunk is changed and not saved yet.";
            LOGGER.severe("Cannot create chunk if the currently loaded chunk is changed and not saved yet.");
            throw new IllegalStateException("Cannot create chunk if the currently loaded chunk is changed and not saved yet.");
        }
        if (this.elementsInFile % (long)this.chunkSize != 0L) {
            String msg = "Cannot create new chunk if there is a chunk with free capacity available.";
            LOGGER.severe("Cannot create new chunk if there is a chunk with free capacity available.");
            throw new IllegalStateException("Cannot create new chunk if there is a chunk with free capacity available.");
        }
        this.data = new Object[this.chunkSize];
        this.elementsInLoadedChunk = 0;
        this.loadedChunkFilePos = this.elementsInFile * this.serializer.getElementLength();
        this.chunkLoaded = true;
        this.changed = false;
    }

    public void saveChunk() throws IOException {
        if (this.chunkLoaded && this.changed) {
            this.raf.seek(this.loadedChunkFilePos);
            this.raf.write(this.serializer.serialise(this.data, this.elementsInLoadedChunk));
            this.elementsInFile = this.raf.length() / this.serializer.getElementLength();
            this.changed = false;
        } else {
            if (!this.chunkLoaded) {
                String msg = "Tried to save the current chunk although there is no chunk loaded.";
                LOGGER.warning("Tried to save the current chunk although there is no chunk loaded.");
                throw new IllegalStateException("Tried to save the current chunk although there is no chunk loaded.");
            }
            if (!this.changed) {
                String msg = "Tried to save the current chunk although it is not changed.";
                LOGGER.info("Tried to save the current chunk although it is not changed.");
            }
        }
    }

    public int getNumberElementsInLoadedChunk() {
        if (!this.chunkLoaded) {
            String msg = "Tried to query number of elements in loaded chunk although there is no chunk loaded.";
            LOGGER.warning("Tried to query number of elements in loaded chunk although there is no chunk loaded.");
            throw new IllegalStateException("Tried to query number of elements in loaded chunk although there is no chunk loaded.");
        }
        return this.elementsInLoadedChunk;
    }

    public int elementCapacityLeft() {
        if (!this.chunkLoaded) {
            return 0;
        }
        return this.chunkSize - this.elementsInLoadedChunk;
    }

    public boolean isChanged() {
        if (!this.chunkLoaded) {
            String msg = "Tried to query changed status although there is no chunk loaded.";
            LOGGER.warning("Tried to query changed status although there is no chunk loaded.");
            throw new IllegalStateException("Tried to query changed status although there is no chunk loaded.");
        }
        return this.changed;
    }

    public long getElementsInFile() {
        return this.elementsInFile;
    }

    public boolean acceptsDataElementIndex(long elementIndex) {
        return this.chunkLoaded && this.indexStartingElementForChunk() <= elementIndex && elementIndex < this.indexStartingElementForChunk() + (long)this.chunkSize;
    }

    public boolean isChunkLoaded() {
        return this.chunkLoaded;
    }
}

