/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.repository.local;

import java.io.File;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.URI;
import org.palladiosimulator.edp2.local.LocalDirectoryRepository;
import org.palladiosimulator.edp2.local.localFactory;

public class LocalDirectoryRepositoryHelper {
    private static final Logger LOGGER = Logger.getLogger(LocalDirectoryRepositoryHelper.class.getCanonicalName());

    public static LocalDirectoryRepository initializeLocalDirectoryRepository(File location) {
        LocalDirectoryRepository ldRepo = localFactory.eINSTANCE.createLocalDirectoryRepository();
        String pathToRepo = location.getAbsolutePath();
        if (!location.exists()) {
            boolean result = location.mkdir();
            if (!result) {
                LOGGER.severe("Could not create directory at location " + pathToRepo);
                return null;
            }
        } else if (!location.isDirectory()) {
            LOGGER.severe("Directory can't be created. A file of the same name already exists. Location: " + pathToRepo);
            return null;
        }
        String uriString = URI.createFileURI((String)pathToRepo).toString();
        ldRepo.setUri(uriString);
        LOGGER.info("The repository has been initialized. Location: " + pathToRepo + ".");
        return ldRepo;
    }
}

