/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.repository.local.dao.internal.backgroundlist.serializer;

import java.util.List;
import org.palladiosimulator.edp2.repository.local.dao.internal.backgroundlist.serializer.LongSerializer;
import org.palladiosimulator.edp2.repository.local.dao.internal.backgroundlist.serializer.Serializer;
import org.palladiosimulator.metricspec.Identifier;
import org.palladiosimulator.metricspec.TextualBaseMetricDescription;

public class IdentifierSerializer
implements Serializer<Identifier> {
    private final LongSerializer internalSerialiser = new LongSerializer();
    private final List<Identifier> allIdentifier;

    public IdentifierSerializer(TextualBaseMetricDescription metricDescription) {
        this.allIdentifier = metricDescription.getIdentifiers();
    }

    @Override
    public long getElementLength() {
        return this.internalSerialiser.getElementLength();
    }

    @Override
    public byte[] serialise(Object[] objects, int count) {
        Object[] internalData = new Long[count];
        int i = 0;
        while (i < count) {
            internalData[i] = (long)this.allIdentifier.indexOf(objects[i]);
            ++i;
        }
        return this.internalSerialiser.serialise(internalData, count);
    }

    public Identifier[] deserialise(byte[] bytes) {
        Long[] internalData = this.internalSerialiser.deserialise(bytes);
        Identifier[] result = new Identifier[internalData.length];
        int i = 0;
        while (i < internalData.length) {
            int index = internalData[i].intValue();
            result[i] = this.allIdentifier.get(index);
            ++i;
        }
        return result;
    }
}

