/**
 */
package org.palladiosimulator.edp2.models.ExperimentData;

import javax.measure.unit.Unit;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Long Binary Measurements</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class is responsible for long measurements. These are stored in IEEE standardized binary format. All values are stored in the same unit. The actual measurements are stored outside the EMF model, see {@link de.uka.ipd.sdq.sensorframework.storage.Daofactory}.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.palladiosimulator.edp2.models.ExperimentData.LongBinaryMeasurements#getStorageUnit <em>Storage Unit</em>}</li>
 * </ul>
 *
 * @see org.palladiosimulator.edp2.models.ExperimentData.ExperimentDataPackage#getLongBinaryMeasurements()
 * @model
 * @generated
 */
public interface LongBinaryMeasurements extends DataSeries
{
	/**
	 * Returns the value of the '<em><b>Storage Unit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Storage Unit</em>' attribute.
	 * @see #setStorageUnit(Unit)
	 * @see org.palladiosimulator.edp2.models.ExperimentData.ExperimentDataPackage#getLongBinaryMeasurements_StorageUnit()
	 * @model dataType="org.palladiosimulator.metricspec.EJSUnit" required="true" ordered="false"
	 * @generated
	 */
	Unit getStorageUnit();

	/**
	 * Sets the value of the '{@link org.palladiosimulator.edp2.models.ExperimentData.LongBinaryMeasurements#getStorageUnit <em>Storage Unit</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Storage Unit</em>' attribute.
	 * @see #getStorageUnit()
	 * @generated
	 */
	void setStorageUnit(Unit value);

} // LongBinaryMeasurements
