/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.ui.dialogs.datasource;

import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Shell;
import org.palladiosimulator.edp2.EDP2Plugin;
import org.palladiosimulator.edp2.impl.RepositoryManager;
import org.palladiosimulator.edp2.models.Repository.Repositories;
import org.palladiosimulator.edp2.models.Repository.Repository;
import org.palladiosimulator.edp2.ui.dialogs.datasource.DatasourceDialog;
import org.palladiosimulator.edp2.ui.wizards.datasource.OpenDataSourceWizard;

public class ConfigureDatasourceDialog
extends DatasourceDialog {
    public static String OPEN_WIZARD_TITLE = "Load a source storage for EDP2.";
    public static String ADD_WIZARD_TITLE = "Select/create a storage for EDP2.";

    public ConfigureDatasourceDialog(Shell parentShell, String dialogTitel, boolean makeValidation) {
        super(parentShell, dialogTitel, EDP2Plugin.INSTANCE.getRepositories().getAvailableRepositories(), makeValidation);
        this.create();
        this.setRemoveButtonAction((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Repository selectedRepository = (Repository)ConfigureDatasourceDialog.this.getResult();
                RepositoryManager.removeRepository((Repositories)EDP2Plugin.INSTANCE.getRepositories(), (Repository)selectedRepository);
                ConfigureDatasourceDialog.this.refresh();
            }
        });
        this.setAddButtonAction((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OpenDataSourceWizard w = new OpenDataSourceWizard();
                WizardDialog dialog = new WizardDialog(e.display.getActiveShell(), (IWizard)w);
                dialog.create();
                dialog.setTitle(ADD_WIZARD_TITLE);
                dialog.open();
                ConfigureDatasourceDialog.this.refresh();
            }
        });
        this.setOpenButtonAction((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OpenDataSourceWizard w = new OpenDataSourceWizard();
                WizardDialog dialog = new WizardDialog(e.display.getActiveShell(), (IWizard)w);
                dialog.create();
                dialog.setTitle(OPEN_WIZARD_TITLE);
                dialog.open();
                ConfigureDatasourceDialog.this.refresh();
            }
        });
    }
}

